package com.tn.lib.thread.dispatcher

import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors
import java.util.concurrent.ScheduledExecutorService
import java.util.concurrent.TimeUnit

/**
 * 延迟任务机制
 * @author: huangyeling
 * @date: 2021/7/29
 */
class DelayDispatcher{

    private var dispatcher: ScheduledExecutorService? = null

    constructor(){
        dispatcher = Executors.newScheduledThreadPool(
            1
        ) { runnable ->
            val thread = Thread(runnable)
            thread.name = "Delay-Task-Dispatcher"
            thread.priority = Thread.MAX_PRIORITY
            thread
        }
    }

    fun postDelay(delay: Long, pool: ExecutorService, runnable: Runnable){
        if(delay == 0L){
            pool.execute(runnable)
            return
        }
        dispatcher?.schedule({pool.execute(runnable)},delay,TimeUnit.MICROSECONDS)
    }

    companion object{
        val instance = DelayDispatcher()
    }

}