package com.tn.lib.thread.dispatcher

import com.tn.lib.thread.callback.AsyncCallback
import com.tn.lib.thread.callback.RunnableCallback
import java.util.concurrent.Executor

/**
 * 异步任务回调委托机制
 * @author: huangyeling
 * @date: 2021/7/28
 */
class RunnableDispatcher : RunnableCallback, AsyncCallback {

    private var runnableCallback: RunnableCallback? = null
    private var deliver: Executor? = null
    private var async: AsyncCallback? = null

    constructor(runnableCallback: RunnableCallback?, deliver: Executor?, async: AsyncCallback?) {
        this.runnableCallback = runnableCallback
        this.deliver = deliver
        this.async = async
    }

    override fun onStart(threadName: String) {
        if (runnableCallback == null) {
            return
        }
        deliver?.execute { runnableCallback?.onStart(threadName) }
    }

    override fun onError(threadName: String, throwable: Throwable) {
        onFailed(throwable)
        if (runnableCallback == null) {
            return
        }
        deliver?.execute { runnableCallback?.onError(threadName, throwable) }
    }

    override fun onCompleted(threadName: String) {
        if (runnableCallback == null) {
            return
        }
        deliver?.execute { runnableCallback?.onCompleted(threadName) }
    }

    override fun onSuccess() {
        if (async == null) {
            return
        }
        deliver?.execute {
            try {
                async?.onSuccess()
            } catch (t: Throwable) {
                onFailed(t)
            }
        }
    }

    override fun onFailed(t: Throwable) {
        if (async == null) {
            return
        }
        deliver?.execute { async?.onFailed(t) }
    }


}
