/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lcom/tn/lib/thread/ThreadPool;", "", "<init>", "()V", "execute", "", "task", "Ljava/lang/Runnable;", "submit", "Ljava/util/concurrent/Future;", "onDestroy", "Companion", "BackgroundThread", "thread_psRelease"})
public final class ThreadPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<ThreadPool> INSTANCE$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, ThreadPool::INSTANCE_delegate$lambda$0);
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = RangesKt.coerceAtMost((int)(CPU_COUNT - 1), (int)4);
    private static final int MAXIMUM_POOL_SIZE = RangesKt.coerceAtMost((int)(CPU_COUNT * 2 + 1), (int)8);
    private static final int KEEP_ALIVE_SECONDS = 30;
    @NotNull
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue(64);
    @NotNull
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount;
        {
            this.mCount = new AtomicInteger(1);
        }

        public Thread newThread(Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            return new BackgroundThread(runnable, "or_threadpool_" + this.mCount.getAndIncrement());
        }
    };
    @Nullable
    private static ThreadPoolExecutor THREAD_POOL_EXECUTOR;

    private ThreadPool() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 30L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        THREAD_POOL_EXECUTOR = threadPoolExecutor;
    }

    public final void execute(@Nullable Runnable task) {
        block0: {
            ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR;
            if (threadPoolExecutor == null) break block0;
            threadPoolExecutor.execute(task);
        }
    }

    @Nullable
    public final Future<?> submit(@Nullable Runnable task) {
        ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR;
        return threadPoolExecutor != null ? threadPoolExecutor.submit(task) : null;
    }

    public final void onDestroy() {
        ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR;
        Intrinsics.checkNotNull((Object)threadPoolExecutor);
        threadPoolExecutor.shutdownNow();
    }

    private static final ThreadPool INSTANCE_delegate$lambda$0() {
        return new ThreadPool();
    }

    @NotNull
    public static final ThreadPool getINSTANCE() {
        return Companion.getINSTANCE();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/tn/lib/thread/ThreadPool$BackgroundThread;", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "name", "", "<init>", "(Ljava/lang/Runnable;Ljava/lang/String;)V", "thread_psRelease"})
    private static final class BackgroundThread
    extends Thread {
        public BackgroundThread(@Nullable Runnable runnable, @Nullable String name) {
            super(runnable, name);
            this.setPriority(5);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tn/lib/thread/ThreadPool$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/tn/lib/thread/ThreadPool;", "getINSTANCE$annotations", "getINSTANCE", "()Lcom/tn/lib/thread/ThreadPool;", "INSTANCE$delegate", "Lkotlin/Lazy;", "CPU_COUNT", "", "CORE_POOL_SIZE", "MAXIMUM_POOL_SIZE", "KEEP_ALIVE_SECONDS", "sPoolWorkQueue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "sThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "THREAD_POOL_EXECUTOR", "Ljava/util/concurrent/ThreadPoolExecutor;", "thread_psRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadPool getINSTANCE() {
            Lazy lazy = INSTANCE$delegate;
            return (ThreadPool)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getINSTANCE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

