/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.thread.wrapper;

import com.tn.lib.thread.config.LocalConfigs;
import com.tn.lib.thread.config.ThreadTools;
import com.tn.lib.thread.dispatcher.RunnableDispatcher;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0001J\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tn/lib/thread/wrapper/RunnableWrapper;", "Ljava/lang/Runnable;", "localConfigs", "Lcom/tn/lib/thread/config/LocalConfigs;", "<init>", "(Lcom/tn/lib/thread/config/LocalConfigs;)V", "threadName", "", "runnable", "dispatcher", "Lcom/tn/lib/thread/dispatcher/RunnableDispatcher;", "callable", "Ljava/util/concurrent/Callable;", "setRunnable", "setCallable", "run", "", "thread_psRelease"})
public final class RunnableWrapper
implements Runnable {
    @NotNull
    private String threadName;
    @Nullable
    private Runnable runnable;
    @NotNull
    private RunnableDispatcher dispatcher;
    @Nullable
    private Callable<?> callable;

    public RunnableWrapper(@NotNull LocalConfigs localConfigs) {
        Intrinsics.checkNotNullParameter((Object)localConfigs, (String)"localConfigs");
        this.threadName = localConfigs.getThreadName();
        this.dispatcher = new RunnableDispatcher(localConfigs.getRunnableCallback(), localConfigs.getDeliver(), localConfigs.getAsyncCallback());
    }

    @NotNull
    public final RunnableWrapper setRunnable(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.runnable = runnable;
        return this;
    }

    @NotNull
    public final RunnableWrapper setCallable(@Nullable Callable<?> callable) {
        this.callable = callable;
        return this;
    }

    @Override
    public void run() {
        block9: {
            block8: {
                Thread currentThread;
                Thread thread = currentThread = Thread.currentThread();
                Intrinsics.checkNotNull((Object)thread);
                ThreadTools.Companion.restThread(thread, this.threadName, this.dispatcher);
                RunnableDispatcher runnableDispatcher = this.dispatcher;
                if (runnableDispatcher != null) {
                    runnableDispatcher.onStart(this.threadName);
                }
                if (this.runnable != null) {
                    Runnable runnable = this.runnable;
                    if (runnable != null) {
                        runnable.run();
                    }
                } else if (this.callable != null) {
                    try {
                        Callable<?> callable = this.callable;
                        Object result = callable != null ? callable.call() : null;
                        RunnableDispatcher runnableDispatcher2 = this.dispatcher;
                        if (runnableDispatcher2 != null) {
                            runnableDispatcher2.onSuccess();
                        }
                    }
                    catch (Exception e) {
                        RunnableDispatcher runnableDispatcher3 = this.dispatcher;
                        if (runnableDispatcher3 == null) break block8;
                        runnableDispatcher3.onError(this.threadName, e);
                    }
                }
            }
            RunnableDispatcher runnableDispatcher = this.dispatcher;
            if (runnableDispatcher == null) break block9;
            runnableDispatcher.onCompleted(this.threadName);
        }
    }
}

