/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay;

import android.content.Context;
import androidx.annotation.UiThread;
import androidx.appcompat.app.AppCompatActivity;
import com.tn.tranpay.BillingParams;
import com.tn.tranpay.BillingResult;
import com.tn.tranpay.PurchasesUpdatedListener;
import com.tn.tranpay.TranPayClient;
import com.tn.tranpay.TranPayConfiguration;
import com.tn.tranpay.activity.TranPayTransparentActivity;
import com.tn.tranpay.fragment.PayLoadingFragment;
import com.tn.tranpay.logger.TranLogger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/tn/tranpay/TranPayClient;", "", "()V", "isDialogShown", "", "launchBillingFlow", "", "context", "Landroid/content/Context;", "params", "Lcom/tn/tranpay/BillingParams;", "callback", "Lcom/tn/tranpay/PurchasesUpdatedListener;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "lib_release"})
public final class TranPayClient {
    @NotNull
    public static final TranPayClient INSTANCE = new TranPayClient();
    private static boolean isDialogShown;

    private TranPayClient() {
    }

    @UiThread
    public final void launchBillingFlow(@NotNull AppCompatActivity activity, @NotNull BillingParams params2, @NotNull PurchasesUpdatedListener callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!TranPayConfiguration.INSTANCE.getHasInitialized()) {
            TranLogger.error$default(TranLogger.INSTANCE, "TranPay must be initialized!", null, 2, null);
            callback.onPurchasesUpdated(new BillingResult(-1, "TranPay must be initialized!"), null);
            return;
        }
        if (isDialogShown) {
            return;
        }
        if (activity.isFinishing() || activity.isDestroyed()) {
            return;
        }
        TranLogger.info$default(TranLogger.INSTANCE, "launchBillingFlow and params is " + params2, null, 2, null);
        try {
            boolean bl = false;
            PayLoadingFragment dialogFragment = PayLoadingFragment.Companion.newInstance(params2, callback);
            dialogFragment.show(activity.getSupportFragmentManager(), "pay_loading_fragment");
            isDialogShown = true;
            dialogFragment.setOnDismissListener((Function0<Unit>)((Function0)launchBillingFlow.1.1.INSTANCE));
            TranPayConfiguration.INSTANCE.syncParamsInfo(params2);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @UiThread
    public final void launchBillingFlow(@NotNull Context context, @NotNull BillingParams params2, @NotNull PurchasesUpdatedListener callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!TranPayConfiguration.INSTANCE.getHasInitialized()) {
            TranLogger.error$default(TranLogger.INSTANCE, "TranPay must be initialized!", null, 2, null);
            callback.onPurchasesUpdated(new BillingResult(-1, "TranPay must be initialized!"), null);
            return;
        }
        if (isDialogShown) {
            return;
        }
        TranLogger.info$default(TranLogger.INSTANCE, "launchBillingFlow with context and params is " + params2, null, 2, null);
        TranPayTransparentActivity.Companion.start(context, params2, callback);
    }

    public static final /* synthetic */ void access$setDialogShown$p(boolean bl) {
        isDialogShown = bl;
    }
}

