/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.activity;

import android.app.Activity;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewbinding.ViewBinding;
import com.gyf.immersionbar.BarHide;
import com.gyf.immersionbar.ImmersionBar;
import com.tn.lib.tranpay.R;
import com.tn.tranpay.logger.TranLogger;
import com.tn.tranpay.report.ILogView;
import com.tn.tranpay.report.LogViewConfig;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0014\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u001a\u0010\u001e\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010#\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010$\u001a\u00020\u0016H\u0014J\b\u0010%\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\b\u0010'\u001a\u00020\u0016H\u0014J\b\u0010(\u001a\u00020\u0016H\u0014J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\u00028\u0000X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/tn/tranpay/activity/BaseActivity;", "T", "Landroidx/viewbinding/ViewBinding;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/tn/tranpay/report/ILogView;", "()V", "TAG", "", "logViewConfig", "Lcom/tn/tranpay/report/LogViewConfig;", "getLogViewConfig", "()Lcom/tn/tranpay/report/LogViewConfig;", "logViewConfig$delegate", "Lkotlin/Lazy;", "mViewBinding", "getMViewBinding", "()Landroidx/viewbinding/ViewBinding;", "setMViewBinding", "(Landroidx/viewbinding/ViewBinding;)V", "Landroidx/viewbinding/ViewBinding;", "getViewBinding", "initView", "", "savedInstanceState", "Landroid/os/Bundle;", "isAttach", "", "isChangeStatusBar", "isStatusDark", "isTranslucent", "loggerPause", "tag", "activity", "Landroid/app/Activity;", "loggerResume", "onCreate", "onDestroy", "onPause", "onResume", "onStart", "onStop", "setImmersionStatusBar", "setStatusBar", "statusColor", "", "lib_release"})
public abstract class BaseActivity<T extends ViewBinding>
extends AppCompatActivity
implements ILogView {
    public T mViewBinding;
    @NotNull
    private final String TAG;
    @NotNull
    private final Lazy logViewConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogViewConfig>(this){
        final /* synthetic */ BaseActivity<T> this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final LogViewConfig invoke() {
            return this.this$0.newLogViewConfig();
        }
    }));

    public BaseActivity() {
        this.TAG = "CommonInfo";
    }

    @NotNull
    public final T getMViewBinding() {
        T t = this.mViewBinding;
        if (t != null) {
            return t;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mViewBinding");
        return null;
    }

    public final void setMViewBinding(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.mViewBinding = t;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setMViewBinding(this.getViewBinding());
        this.initView(savedInstanceState);
        this.setStatusBar();
    }

    protected void onStart() {
        super.onStart();
    }

    public void initView(@Nullable Bundle savedInstanceState) {
    }

    @NotNull
    public abstract T getViewBinding();

    public void setStatusBar() {
        if (!this.setImmersionStatusBar()) {
            return;
        }
        ImmersionBar with = ImmersionBar.with((Activity)((Activity)this)).fullScreen(true);
        if (this.isChangeStatusBar()) {
            with.statusBarColor(this.statusColor());
        }
        with.hideBar(BarHide.FLAG_HIDE_NAVIGATION_BAR);
        if (this.isTranslucent()) {
            with.statusBarAlpha(0.0f);
        } else {
            with.statusBarAlpha(1.0f);
        }
        if (this.isStatusDark()) {
            with.statusBarDarkFont(true);
        }
        with.init();
    }

    public boolean setImmersionStatusBar() {
        return true;
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public boolean isChangeStatusBar() {
        return false;
    }

    public int statusColor() {
        return R.color.white;
    }

    public boolean isStatusDark() {
        return true;
    }

    public boolean isTranslucent() {
        return false;
    }

    @Override
    @Nullable
    public LogViewConfig getLogViewConfig() {
        Lazy lazy = this.logViewConfig$delegate;
        return (LogViewConfig)lazy.getValue();
    }

    @Override
    public void onResume() {
        super.onResume();
        ILogView.DefaultImpls.onResume(this);
        BaseActivity.loggerResume$default(this, null, (Activity)this, 1, null);
    }

    public boolean isAttach() {
        return true;
    }

    @Override
    public void onPause() {
        super.onPause();
        ILogView.DefaultImpls.onPause(this);
        BaseActivity.loggerPause$default(this, null, (Activity)this, 1, null);
    }

    private final void loggerResume(String tag, Activity activity) {
        TranLogger.INSTANCE.info(tag, activity.getLocalClassName() + " onResume");
    }

    static /* synthetic */ void loggerResume$default(BaseActivity baseActivity, String string, Activity activity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loggerResume");
        }
        if ((n & 1) != 0) {
            string = baseActivity.TAG;
        }
        baseActivity.loggerResume(string, activity);
    }

    private final void loggerPause(String tag, Activity activity) {
        TranLogger.INSTANCE.info(tag, activity.getLocalClassName() + " onPause");
    }

    static /* synthetic */ void loggerPause$default(BaseActivity baseActivity, String string, Activity activity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loggerPause");
        }
        if ((n & 1) != 0) {
            string = baseActivity.TAG;
        }
        baseActivity.loggerPause(string, activity);
    }

    @Override
    @Nullable
    public LogViewConfig newLogViewConfig() {
        return ILogView.DefaultImpls.newLogViewConfig(this);
    }
}

