/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.device;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.blankj.utilcode.util.Utils;
import com.tencent.mmkv.MMKV;
import com.tn.tranpay.device.MD5;
import com.tn.tranpay.device.TNDeviceHelper;
import com.tn.tranpay.device.oaid.OAIDService;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/tn/tranpay/device/TNDeviceHelper;", "", "()V", "GID_ACTION", "", "GMS_PACKAGE", "STABLE_ANDROID_ID", "kvAndroidId", "kvDeviceId", "kvGmsAdId", "tranMmkv", "Lcom/tencent/mmkv/MMKV;", "getTranMmkv", "()Lcom/tencent/mmkv/MMKV;", "tranMmkv$delegate", "Lkotlin/Lazy;", "doGetGid", "", "context", "Landroid/content/Context;", "getAndroidId", "getBrand", "getDeviceId", "getGaid", "getModel", "getOsVersion", "saveAndroidId", "androidId", "saveDeviceId", "deviceId", "saveGaid", "gid", "lib_release"})
public final class TNDeviceHelper {
    @NotNull
    public static final TNDeviceHelper INSTANCE = new TNDeviceHelper();
    @NotNull
    private static final Lazy tranMmkv$delegate = LazyKt.lazy((Function0)tranMmkv.2.INSTANCE);
    @Nullable
    private static String kvAndroidId;
    @Nullable
    private static String kvGmsAdId;
    @Nullable
    private static String kvDeviceId;
    @NotNull
    private static final String GID_ACTION = "com.google.android.gms.ads.identifier.service.START";
    @NotNull
    private static final String GMS_PACKAGE = "com.google.android.gms";
    @NotNull
    private static final String STABLE_ANDROID_ID = "9774d56d682e549c";

    private TNDeviceHelper() {
    }

    private final MMKV getTranMmkv() {
        Lazy lazy = tranMmkv$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-tranMmkv>(...)");
        return (MMKV)object;
    }

    public final void doGetGid(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof Application)) {
            System.out.println((Object)"please pass in application to avoid Service not registered exception ");
            return;
        }
        String gid = this.getTranMmkv().getString("sdk_ga_id", "");
        if (!TextUtils.isEmpty((CharSequence)gid)) {
            System.out.println((Object)("gid has get gid " + gid));
            return;
        }
        Intent intent = new Intent(GID_ACTION);
        intent.setPackage(GMS_PACKAGE);
        OAIDService.Companion.bind(context, intent);
    }

    public final void saveGaid(@NotNull String gid) {
        Intrinsics.checkNotNullParameter((Object)gid, (String)"gid");
        this.getTranMmkv().putString("sdk_ga_id", gid);
    }

    public final void saveAndroidId(@NotNull String androidId) {
        Intrinsics.checkNotNullParameter((Object)androidId, (String)"androidId");
        this.getTranMmkv().putString("sdk_android_id", androidId);
    }

    @NotNull
    public final String getAndroidId() {
        String string;
        String androidId;
        if (TextUtils.isEmpty((CharSequence)kvAndroidId)) {
            kvAndroidId = this.getTranMmkv().getString("sdk_android_id", "");
        }
        if (TextUtils.isEmpty((CharSequence)(androidId = kvAndroidId))) {
            Application application = Utils.getApp();
            androidId = Settings.System.getString((ContentResolver)(application != null ? application.getContentResolver() : null), (String)"android_id");
        }
        if ((string = androidId) == null) {
            string = "";
        }
        return string;
    }

    public final void saveDeviceId(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.getTranMmkv().putString("sdk_device_id", deviceId);
    }

    @NotNull
    public final String getGaid() {
        String gaid;
        if (TextUtils.isEmpty((CharSequence)kvGmsAdId)) {
            kvGmsAdId = this.getTranMmkv().getString("sdk_ga_id", "");
        }
        if (!TextUtils.isEmpty((CharSequence)(gaid = String.valueOf(kvGmsAdId)))) {
            return gaid;
        }
        String android = this.getAndroidId();
        if (!TextUtils.isEmpty((CharSequence)android)) {
            return android;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @NotNull
    public final String getBrand() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        return string;
    }

    @NotNull
    public final String getModel() {
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        return string;
    }

    @NotNull
    public final String getOsVersion() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
        return string;
    }

    @NotNull
    public final String getDeviceId() {
        if (TextUtils.isEmpty((CharSequence)kvDeviceId)) {
            kvDeviceId = this.getTranMmkv().getString("sdk_device_id", "");
        }
        String deviceId = String.valueOf(kvDeviceId);
        if (TextUtils.isEmpty((CharSequence)kvAndroidId)) {
            kvAndroidId = this.getTranMmkv().getString("sdk_android_id", "");
        }
        String androidId = String.valueOf(kvAndroidId);
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        if (!TextUtils.isEmpty((CharSequence)androidId)) {
            String decodeAndroidId = MD5.Companion.getStringMD5(androidId);
            this.saveDeviceId(decodeAndroidId);
            return decodeAndroidId;
        }
        Application application = Utils.getApp();
        String string = Settings.System.getString((ContentResolver)(application != null ? application.getContentResolver() : null), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(\n            U\u2026cure.ANDROID_ID\n        )");
        androidId = string;
        if (!TextUtils.isEmpty((CharSequence)androidId) && !Intrinsics.areEqual((Object)androidId, (Object)STABLE_ANDROID_ID)) {
            deviceId = MD5.Companion.getStringMD5(androidId);
            this.saveDeviceId(deviceId);
            this.saveAndroidId(androidId);
        } else {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            String uuid = string2;
            deviceId = MD5.Companion.getStringMD5(uuid);
            this.saveDeviceId(deviceId);
        }
        return deviceId;
    }
}

