/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.fragment;

import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.tn.lib.tranpay.R;
import com.tn.tranpay.BillingParams;
import com.tn.tranpay.adapter.PayMethodAdapter;
import com.tn.tranpay.bean.InputInfoBean;
import com.tn.tranpay.bean.LoadConfigContent;
import com.tn.tranpay.bean.MediumInputBean;
import com.tn.tranpay.fragment.PayFragment;
import com.tn.tranpay.fragment.PaySubFragment;
import com.tn.tranpay.helper.FastClickUtils;
import com.tn.tranpay.helper.PaymentMMKV;
import com.tn.tranpay.logger.TranLogger;
import com.tn.tranpay.report.TranPayReport;
import com.tn.tranpay.viewmodel.PaymentViewModel;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0002J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\fH\u0002J,\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u001a\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\u00182\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010$\u001a\u00020\u00182\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/tn/tranpay/fragment/PayMainFragment;", "Landroidx/fragment/app/Fragment;", "()V", "configBean", "Lcom/tn/tranpay/bean/LoadConfigContent;", "isPayable", "", "payMethodAdapter", "Lcom/tn/tranpay/adapter/PayMethodAdapter;", "paymentParams", "Lcom/tn/tranpay/BillingParams;", "usedMethodCode", "", "viewModel", "Lcom/tn/tranpay/viewmodel/PaymentViewModel;", "getViewModel", "()Lcom/tn/tranpay/viewmodel/PaymentViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "canShowFrequentlyTag", "list", "", "Lcom/tn/tranpay/bean/MediumInputBean;", "handleItemClick", "", "item", "view", "Landroid/view/View;", "phone", "cnic", "navigateToSubFragment", "needCnic", "onViewCreated", "savedInstanceState", "Landroid/os/Bundle;", "setConfigInfo", "setPayMethodList", "setupRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nPayMainFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayMainFragment.kt\ncom/tn/tranpay/fragment/PayMainFragment\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n56#2,10:180\n1747#3,3:190\n1747#3,3:193\n1747#3,3:196\n*S KotlinDebug\n*F\n+ 1 PayMainFragment.kt\ncom/tn/tranpay/fragment/PayMainFragment\n*L\n49#1:180,10\n83#1:190,3\n110#1:193,3\n111#1:196,3\n*E\n"})
public final class PayMainFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BillingParams paymentParams;
    @Nullable
    private LoadConfigContent configBean;
    private PayMethodAdapter payMethodAdapter;
    @NotNull
    private final Lazy viewModel$delegate;
    private boolean isPayable;
    @Nullable
    private String usedMethodCode;
    @NotNull
    private static final String PAYMENT_PARAMS = "paymentParams";
    @NotNull
    private static final String CONFIG_BEAN = "configBean";

    /*
     * WARNING - void declaration
     */
    public PayMainFragment() {
        super(R.layout.tran_fragment_main_layout);
        void $this$viewModels_u24default$iv;
        Fragment fragment = this;
        Function0 ownerProducer$iv = (Function0)new Function0<ViewModelStoreOwner>(this){
            final /* synthetic */ PayMainFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStoreOwner invoke() {
                Fragment fragment = this.this$0.requireParentFragment();
                Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"requireParentFragment()");
                return (ViewModelStoreOwner)fragment;
            }
        };
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        this.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$viewModels_u24default$iv, (KClass)Reflection.getOrCreateKotlinClass(PaymentViewModel.class), (Function0)((Function0)new Function0<ViewModelStore>(ownerProducer$iv){
            final /* synthetic */ Function0 $ownerProducer;
            {
                this.$ownerProducer = $ownerProducer;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = ((ViewModelStoreOwner)this.$ownerProducer.invoke()).getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"ownerProducer().viewModelStore");
                return viewModelStore;
            }
        }), (Function0)((Function0)new Function0<ViewModelProvider.Factory>(ownerProducer$iv, (Fragment)$this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $ownerProducer;
            final /* synthetic */ Fragment $this_viewModels;
            {
                this.$ownerProducer = $ownerProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                Object object = this.$ownerProducer.invoke();
                HasDefaultViewModelProviderFactory hasDefaultViewModelProviderFactory = object instanceof HasDefaultViewModelProviderFactory ? (HasDefaultViewModelProviderFactory)object : null;
                ViewModelProvider.Factory factory = hasDefaultViewModelProviderFactory == null ? null : hasDefaultViewModelProviderFactory.getDefaultViewModelProviderFactory();
                ViewModelProvider.Factory factory2 = factory == null ? this.$this_viewModels.getDefaultViewModelProviderFactory() : factory;
                Intrinsics.checkNotNullExpressionValue((Object)factory2, (String)"(ownerProducer() as? Has\u2026tViewModelProviderFactory");
                return factory2;
            }
        }));
        this.isPayable = true;
    }

    private final PaymentViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (PaymentViewModel)((Object)lazy.getValue());
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Bundle bundle = this.getArguments();
        this.paymentParams = bundle != null ? (BillingParams)bundle.getParcelable(PAYMENT_PARAMS) : null;
        Bundle bundle2 = this.getArguments();
        this.configBean = bundle2 != null ? (LoadConfigContent)bundle2.getParcelable(CONFIG_BEAN) : null;
        ((AppCompatImageView)view.findViewById(R.id.iv_close)).setOnClickListener(arg_0 -> PayMainFragment.onViewCreated$lambda$0(this, arg_0));
        this.usedMethodCode = PaymentMMKV.INSTANCE.getMmkv().getString("k_pay_method_code", null);
        TranLogger.info$default(TranLogger.INSTANCE, "The used method code is " + this.usedMethodCode, null, 2, null);
        View view2 = view.findViewById(R.id.iv_recycler);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById(R.id.iv_recycler)");
        RecyclerView ivRecyclerView = (RecyclerView)view2;
        this.setupRecyclerView(ivRecyclerView);
        if (this.isAdded()) {
            LoadConfigContent loadConfigContent = this.configBean;
            this.setPayMethodList(loadConfigContent != null ? loadConfigContent.getMedium() : null);
            this.setConfigInfo(this.configBean);
        }
        TranPayReport.INSTANCE.reportTabPagePT("main_tab_page");
    }

    private final void setupRecyclerView(RecyclerView recyclerView) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
    }

    private final boolean canShowFrequentlyTag(List<MediumInputBean> list) {
        boolean bl;
        List<MediumInputBean> list2 = list;
        if (list2 != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MediumInputBean it = (MediumInputBean)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)this.usedMethodCode)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void setPayMethodList(List<MediumInputBean> list) {
        block2: {
            void $this$setPayMethodList_u24lambda_u243_u24lambda_u242;
            PayMethodAdapter payMethodAdapter;
            List<MediumInputBean> list2 = list;
            if (list2 == null) break block2;
            List<MediumInputBean> it = list2;
            boolean bl = false;
            String phone = PaymentMMKV.INSTANCE.getMmkv().getString("k_phone_number", null);
            String cnic = PaymentMMKV.INSTANCE.getMmkv().getString("k_cnic_number", null);
            PayMethodAdapter payMethodAdapter2 = payMethodAdapter = new PayMethodAdapter(CollectionsKt.toMutableList((Collection)it), this.canShowFrequentlyTag(it), this.usedMethodCode);
            PayMainFragment payMainFragment = this;
            boolean bl2 = false;
            int[] nArray = new int[]{R.id.item_root};
            $this$setPayMethodList_u24lambda_u243_u24lambda_u242.addChildClickViewIds(nArray);
            $this$setPayMethodList_u24lambda_u243_u24lambda_u242.setClickCallback((Function2<? super MediumInputBean, ? super View, Unit>)((Function2)new Function2<MediumInputBean, View, Unit>(this, phone, cnic){
                final /* synthetic */ PayMainFragment this$0;
                final /* synthetic */ String $phone;
                final /* synthetic */ String $cnic;
                {
                    this.this$0 = $receiver;
                    this.$phone = $phone;
                    this.$cnic = $cnic;
                    super(2);
                }

                public final void invoke(@NotNull MediumInputBean item, @NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    PayMainFragment.access$handleItemClick(this.this$0, item, view, this.$phone, this.$cnic);
                }
            }));
            payMainFragment.payMethodAdapter = payMethodAdapter;
            View view = this.getView();
            RecyclerView recyclerView = view != null ? (RecyclerView)view.findViewById(R.id.iv_recycler) : null;
            if (recyclerView != null) {
                PayMethodAdapter payMethodAdapter3 = this.payMethodAdapter;
                if (payMethodAdapter3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"payMethodAdapter");
                    payMethodAdapter3 = null;
                }
                recyclerView.setAdapter((RecyclerView.Adapter)payMethodAdapter3);
            }
        }
    }

    private final void handleItemClick(MediumInputBean item, View view, String phone, String cnic) {
        String string2;
        boolean needCnic;
        boolean bl;
        if (!this.isPayable) {
            TranLogger.info$default(TranLogger.INSTANCE, "It's illegal that the method is not payable", null, 2, null);
            return;
        }
        TranLogger.info$default(TranLogger.INSTANCE, "Choose method " + item.getCode(), null, 2, null);
        if (FastClickUtils.INSTANCE.isFastClick(view.getId(), 2000L)) {
            return;
        }
        this.isPayable = false;
        List<InputInfoBean> list = item.getInputs();
        if (list != null) {
            boolean bl2;
            block20: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        InputInfoBean it = (InputInfoBean)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)"Phone")) continue;
                        bl2 = true;
                        break block20;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        boolean needPhone = bl;
        List<InputInfoBean> list2 = item.getInputs();
        if (list2 != null) {
            boolean bl4;
            block21: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        InputInfoBean it = (InputInfoBean)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)"CNIC")) continue;
                        bl4 = true;
                        break block21;
                    }
                    bl4 = false;
                }
            }
            v5 = bl4;
        } else {
            v5 = needCnic = false;
        }
        if ((string2 = item.getCode()) == null) {
            string2 = "";
        }
        TranPayReport.INSTANCE.reportChoosePaymentMethod(string2, needPhone, needCnic, false);
        if (needPhone && needCnic) {
            this.navigateToSubFragment(item, phone, cnic, true);
        } else if (needPhone) {
            this.navigateToSubFragment(item, phone, cnic, false);
        } else if (needCnic) {
            TranLogger.error$default(TranLogger.INSTANCE, "It's illegal that doesn't exist only cnic", null, 2, null);
        } else {
            PaymentViewModel paymentViewModel = this.getViewModel();
            String string3 = item.getCode();
            if (string3 == null) {
                string3 = "";
            }
            PaymentViewModel.cashierPay$default(paymentViewModel, string3, null, null, false, 14, null);
        }
    }

    private final void navigateToSubFragment(MediumInputBean item, String phone, String cnic, boolean needCnic) {
        block3: {
            PaySubFragment paySubFragment;
            String string2;
            String string3;
            BillingParams billingParams = this.paymentParams;
            if (billingParams == null) break block3;
            BillingParams it = billingParams;
            boolean bl = false;
            List list = item.getInputs();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if ((string3 = item.getName()) == null) {
                string3 = "";
            }
            if ((string2 = item.getCode()) == null) {
                string2 = "";
            }
            PaySubFragment $this$navigateToSubFragment_u24lambda_u248_u24lambda_u246 = paySubFragment = PaySubFragment.Companion.newInstance(it, this.configBean, needCnic, list, string3, string2, phone, cnic);
            boolean bl2 = false;
            $this$navigateToSubFragment_u24lambda_u248_u24lambda_u246.setOnFragmentPopped((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ PayMainFragment this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    PayMainFragment.access$setPayable$p(this.this$0, true);
                    PayMainFragment.access$getViewModel(this.this$0).getLoadingLiveData().postValue((Object)false);
                    TranLogger.info$default(TranLogger.INSTANCE, "PaySubFragment popped", null, 2, null);
                }
            }));
            PaySubFragment it2 = paySubFragment;
            boolean bl3 = false;
            this.getParentFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)it2).addToBackStack(null).commit();
        }
    }

    private final void setConfigInfo(LoadConfigContent configBean) {
        block1: {
            LoadConfigContent loadConfigContent = configBean;
            if (loadConfigContent == null) break block1;
            LoadConfigContent it = loadConfigContent;
            boolean bl = false;
            View view = this.getView();
            if (view != null) {
                View view2;
                View $this$setConfigInfo_u24lambda_u2410_u24lambda_u249 = view2 = view;
                boolean bl2 = false;
                ((AppCompatTextView)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.findViewById(R.id.iv_company)).setText((CharSequence)it.getCpName());
                Object[] objectArray = new Object[]{it.getSymbol()};
                ((AppCompatTextView)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.findViewById(R.id.iv_amount)).setText((CharSequence)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.getContext().getString(R.string.pay_amount, objectArray));
                objectArray = new Object[]{it.getSymbol(), it.getCpName()};
                ((AppCompatTextView)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.findViewById(R.id.iv_desc)).setText((CharSequence)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.getContext().getString(R.string.pay_desc, objectArray));
                objectArray = new Object[]{it.getOrderId()};
                ((AppCompatTextView)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.findViewById(R.id.iv_order_id)).setText((CharSequence)$this$setConfigInfo_u24lambda_u2410_u24lambda_u249.getContext().getString(R.string.pay_order, objectArray));
            }
        }
    }

    private static final void onViewCreated$lambda$0(PayMainFragment this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Fragment fragment = this$0.getParentFragment();
            PayFragment payFragment = fragment instanceof PayFragment ? (PayFragment)fragment : null;
            if (payFragment == null) break block0;
            payFragment.handleDismiss();
        }
    }

    public static final /* synthetic */ void access$handleItemClick(PayMainFragment $this, MediumInputBean item, View view, String phone, String cnic) {
        $this.handleItemClick(item, view, phone, cnic);
    }

    public static final /* synthetic */ void access$setPayable$p(PayMainFragment $this, boolean bl) {
        $this.isPayable = bl;
    }

    public static final /* synthetic */ PaymentViewModel access$getViewModel(PayMainFragment $this) {
        return $this.getViewModel();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/tn/tranpay/fragment/PayMainFragment$Companion;", "", "()V", "CONFIG_BEAN", "", "PAYMENT_PARAMS", "newInstance", "Lcom/tn/tranpay/fragment/PayMainFragment;", "params", "Lcom/tn/tranpay/BillingParams;", "configBean", "Lcom/tn/tranpay/bean/LoadConfigContent;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PayMainFragment newInstance(@NotNull BillingParams params2, @Nullable LoadConfigContent configBean) {
            void $this$newInstance_u24lambda_u241_u24lambda_u240;
            Bundle bundle;
            PayMainFragment payMainFragment;
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            PayMainFragment $this$newInstance_u24lambda_u241 = payMainFragment = new PayMainFragment();
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            PayMainFragment payMainFragment2 = $this$newInstance_u24lambda_u241;
            boolean bl2 = false;
            $this$newInstance_u24lambda_u241_u24lambda_u240.putParcelable(PayMainFragment.PAYMENT_PARAMS, (Parcelable)params2);
            $this$newInstance_u24lambda_u241_u24lambda_u240.putParcelable(PayMainFragment.CONFIG_BEAN, (Parcelable)configBean);
            payMainFragment2.setArguments(bundle);
            return payMainFragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

