/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.helper;

import com.google.gson.Gson;
import com.tencent.mmkv.MMKV;
import com.tn.tranpay.bean.CurrencyInfoBean;
import com.tn.tranpay.device.TNDeviceHelper;
import com.tn.tranpay.helper.IPHelper;
import com.tn.tranpay.helper.PaymentMMKV;
import com.tn.tranpay.logger.TranLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0017J\u0013\u0010 \u001a\u0004\u0018\u00010\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/tn/tranpay/helper/PaymentMMKV;", "", "()V", "K_CNIC_NUMBER", "", "K_CURRENCY_INFO_CACHE_PREFIX", "K_CURRENCY_INFO_CACHE_TIME_PREFIX", "K_CURRENCY_INFO_IP_CACHE_PREFIX", "K_PAY_METHOD_CODE", "K_PHONE_NUMBER", "REGION_CACHE_EXPIRY_TIME", "", "dateFormat", "Ljava/text/SimpleDateFormat;", "gson", "Lcom/google/gson/Gson;", "mmkv", "Lcom/tencent/mmkv/MMKV;", "getMmkv", "()Lcom/tencent/mmkv/MMKV;", "mmkv$delegate", "Lkotlin/Lazy;", "cacheCurrencyInfoByIP", "", "currencyInfo", "Lcom/tn/tranpay/bean/CurrencyInfoBean;", "(Lcom/tn/tranpay/bean/CurrencyInfoBean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cacheCurrencyInfoByRegion", "region", "clearAllExpiredCache", "clearExpiredIPCache", "clearExpiredRegionCache", "getCachedCurrencyInfoByIP", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCachedCurrencyInfoByRegion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nPaymentMMKV.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMMKV.kt\ncom/tn/tranpay/helper/PaymentMMKV\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,231:1\n13309#2,2:232\n13309#2,2:234\n*S KotlinDebug\n*F\n+ 1 PaymentMMKV.kt\ncom/tn/tranpay/helper/PaymentMMKV\n*L\n187#1:232,2\n210#1:234,2\n*E\n"})
public final class PaymentMMKV {
    @NotNull
    public static final PaymentMMKV INSTANCE = new PaymentMMKV();
    @NotNull
    private static final Lazy mmkv$delegate = LazyKt.lazy((Function0)mmkv.2.INSTANCE);
    @NotNull
    public static final String K_PAY_METHOD_CODE = "k_pay_method_code";
    @NotNull
    public static final String K_PHONE_NUMBER = "k_phone_number";
    @NotNull
    public static final String K_CNIC_NUMBER = "k_cnic_number";
    @NotNull
    public static final String K_CURRENCY_INFO_CACHE_PREFIX = "k_currency_info_cache_";
    @NotNull
    public static final String K_CURRENCY_INFO_IP_CACHE_PREFIX = "k_currency_info_ip_cache_";
    @NotNull
    public static final String K_CURRENCY_INFO_CACHE_TIME_PREFIX = "k_currency_info_cache_time_";
    @NotNull
    private static final Gson gson = new Gson();
    @NotNull
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
    private static final long REGION_CACHE_EXPIRY_TIME = 2592000000L;

    private PaymentMMKV() {
    }

    @NotNull
    public final MMKV getMmkv() {
        Lazy lazy = mmkv$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-mmkv>(...)");
        return (MMKV)object;
    }

    public final void cacheCurrencyInfoByRegion(@NotNull String region, @NotNull CurrencyInfoBean currencyInfo) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)currencyInfo, (String)"currencyInfo");
        String key = K_CURRENCY_INFO_CACHE_PREFIX + region;
        String timeKey = K_CURRENCY_INFO_CACHE_TIME_PREFIX + region;
        try {
            String jsonString = gson.toJson((Object)currencyInfo);
            this.getMmkv().putString(key, jsonString);
            this.getMmkv().putLong(timeKey, System.currentTimeMillis());
        }
        catch (Exception e) {
            TranLogger.error$default(TranLogger.INSTANCE, "\u7f13\u5b58region\u8d27\u5e01\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), null, 2, null);
        }
    }

    @Nullable
    public final CurrencyInfoBean getCachedCurrencyInfoByRegion(@NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        String key = K_CURRENCY_INFO_CACHE_PREFIX + region;
        String timeKey = K_CURRENCY_INFO_CACHE_TIME_PREFIX + region;
        long cacheTime = this.getMmkv().getLong(timeKey, 0L);
        long currentTime = System.currentTimeMillis();
        if (cacheTime == 0L || currentTime - cacheTime > 2592000000L) {
            this.getMmkv().removeValueForKey(key);
            this.getMmkv().removeValueForKey(timeKey);
            return null;
        }
        String jsonString = this.getMmkv().getString(key, "");
        Object object = jsonString;
        if (object == null || object.length() == 0) {
            return null;
        }
        try {
            object = (CurrencyInfoBean)gson.fromJson(jsonString, CurrencyInfoBean.class);
        }
        catch (Exception e) {
            TranLogger.error$default(TranLogger.INSTANCE, "\u89e3\u6790region\u7f13\u5b58\u5931\u8d25: " + e.getMessage(), null, 2, null);
            this.getMmkv().removeValueForKey(key);
            this.getMmkv().removeValueForKey(timeKey);
            object = null;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object cacheCurrencyInfoByIP(@NotNull CurrencyInfoBean var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof cacheCurrencyInfoByIP.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PaymentMMKV this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cacheCurrencyInfoByIP(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = currencyInfo;
                $continuation.label = 1;
                v0 = IPHelper.getCurrentIP$default(IPHelper.INSTANCE, false, (Continuation)$continuation, 1, null);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                currencyInfo = (CurrencyInfoBean)$continuation.L$1;
                this = (PaymentMMKV)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((var4_7 = (CharSequence)(currentIP = (String)v0)) == null || StringsKt.isBlank((CharSequence)var4_7) != false) {
                    TranLogger.error$default(TranLogger.INSTANCE, "\u65e0\u6cd5\u83b7\u53d6IP\u5730\u5740\uff0c\u4f7f\u7528\u8bbe\u5907ID\u4f5c\u4e3afallback", null, 2, null);
                    deviceId = TNDeviceHelper.INSTANCE.getDeviceId();
                    today = PaymentMMKV.dateFormat.format(new Date());
                    key = "k_currency_info_ip_cache_device_" + deviceId + "_" + today;
                    try {
                        jsonString = PaymentMMKV.gson.toJson((Object)currencyInfo);
                        this.getMmkv().putString(key, jsonString);
                        TranLogger.info$default(TranLogger.INSTANCE, "\u4f7f\u7528\u8bbe\u5907ID\u7f13\u5b58\u8d27\u5e01\u4fe1\u606f: " + deviceId, null, 2, null);
                    }
                    catch (Exception e) {
                        TranLogger.error$default(TranLogger.INSTANCE, "\u7f13\u5b58\u8d27\u5e01\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), null, 2, null);
                    }
                    return Unit.INSTANCE;
                }
                today = PaymentMMKV.dateFormat.format(new Date());
                key = "k_currency_info_ip_cache_" + currentIP + "_" + today;
                try {
                    jsonString = PaymentMMKV.gson.toJson((Object)currencyInfo);
                    this.getMmkv().putString(key, jsonString);
                    TranLogger.info$default(TranLogger.INSTANCE, "\u4f7f\u7528IP\u5730\u5740\u7f13\u5b58\u8d27\u5e01\u4fe1\u606f: " + currentIP, null, 2, null);
                }
                catch (Exception e) {
                    TranLogger.error$default(TranLogger.INSTANCE, "\u7f13\u5b58\u8d27\u5e01\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), null, 2, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getCachedCurrencyInfoByIP(@NotNull Continuation<? super CurrencyInfoBean> var1_1) {
        if (!(var1_1 instanceof getCachedCurrencyInfoByIP.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PaymentMMKV this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCachedCurrencyInfoByIP((Continuation<? super CurrencyInfoBean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                today = PaymentMMKV.dateFormat.format(new Date());
                $continuation.L$0 = this;
                $continuation.L$1 = today;
                $continuation.label = 1;
                v0 = IPHelper.getCurrentIP$default(IPHelper.INSTANCE, false, (Continuation)$continuation, 1, null);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                today = (String)$continuation.L$1;
                this = (PaymentMMKV)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (!((var4_7 = (CharSequence)(currentIP = (String)v0)) == null || StringsKt.isBlank((CharSequence)var4_7) != false)) {
                    ipKey = "k_currency_info_ip_cache_" + currentIP + "_" + today;
                    jsonString = this.getMmkv().getString(ipKey, "");
                    var6_9 = jsonString;
                    if (!(var6_9 == null || var6_9.length() == 0)) {
                        try {
                            result = (CurrencyInfoBean)PaymentMMKV.gson.fromJson(jsonString, CurrencyInfoBean.class);
                            TranLogger.info$default(TranLogger.INSTANCE, "\u4f7f\u7528IP\u5730\u5740\u7f13\u5b58: " + currentIP, null, 2, null);
                        }
                        catch (Exception e) {
                            TranLogger.error$default(TranLogger.INSTANCE, "\u89e3\u6790IP\u7f13\u5b58\u5931\u8d25: " + e.getMessage(), null, 2, null);
                            this.getMmkv().removeValueForKey(ipKey);
                            result = null;
                        }
                        return result;
                    }
                }
                deviceId = TNDeviceHelper.INSTANCE.getDeviceId();
                deviceKey = "k_currency_info_ip_cache_device_" + deviceId + "_" + today;
                deviceJsonString = this.getMmkv().getString(deviceKey, "");
                e = deviceJsonString;
                if (!(e == null || e.length() == 0)) {
                    try {
                        result = (CurrencyInfoBean)PaymentMMKV.gson.fromJson(deviceJsonString, CurrencyInfoBean.class);
                        TranLogger.info$default(TranLogger.INSTANCE, "\u4f7f\u7528\u8bbe\u5907ID fallback\u7f13\u5b58: " + deviceId, null, 2, null);
                        var7_11 = result;
                    }
                    catch (Exception e) {
                        TranLogger.error$default(TranLogger.INSTANCE, "\u89e3\u6790\u8bbe\u5907ID\u7f13\u5b58\u5931\u8d25: " + e.getMessage(), null, 2, null);
                        this.getMmkv().removeValueForKey(deviceKey);
                        var7_11 = null;
                    }
                    return var7_11;
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void clearExpiredIPCache() {
        block1: {
            String[] allKeys;
            String today = dateFormat.format(new Date());
            if (allKeys == null) break block1;
            String[] $this$forEach$iv = allKeys = this.getMmkv().allKeys();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String dateStr;
                int lastUnderscoreIndex;
                String element$iv;
                String key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                if (!StringsKt.startsWith$default((String)key, (String)K_CURRENCY_INFO_IP_CACHE_PREFIX, (boolean)false, (int)2, null) || (lastUnderscoreIndex = StringsKt.lastIndexOf$default((CharSequence)key, (String)"_", (int)0, (boolean)false, (int)6, null)) == -1 || lastUnderscoreIndex >= key.length() - 1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key.substring(lastUnderscoreIndex + 1), (String)"substring(...)");
                if (Intrinsics.areEqual((Object)dateStr, (Object)today)) continue;
                INSTANCE.getMmkv().removeValueForKey(key);
                TranLogger.info$default(TranLogger.INSTANCE, "\u6e05\u9664\u8fc7\u671fIP\u7f13\u5b58: " + key, null, 2, null);
            }
        }
    }

    public final void clearExpiredRegionCache() {
        block1: {
            String[] allKeys;
            long currentTime = System.currentTimeMillis();
            if (allKeys == null) break block1;
            String[] $this$forEach$iv = allKeys = this.getMmkv().allKeys();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                long cacheTime;
                String element$iv;
                String key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                if (!StringsKt.startsWith$default((String)key, (String)K_CURRENCY_INFO_CACHE_TIME_PREFIX, (boolean)false, (int)2, null) || (cacheTime = INSTANCE.getMmkv().getLong(key, 0L)) <= 0L || currentTime - cacheTime <= 2592000000L) continue;
                String region = StringsKt.removePrefix((String)key, (CharSequence)K_CURRENCY_INFO_CACHE_TIME_PREFIX);
                String dataKey = K_CURRENCY_INFO_CACHE_PREFIX + region;
                INSTANCE.getMmkv().removeValueForKey(dataKey);
                INSTANCE.getMmkv().removeValueForKey(key);
            }
        }
    }

    public final void clearAllExpiredCache() {
        this.clearExpiredIPCache();
        this.clearExpiredRegionCache();
    }
}

