/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.logger;

import android.util.Log;
import com.tn.tranpay.logger.LogLevel;
import com.tn.tranpay.logger.LoggerPlugin;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004J\u001a\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\u0006J\"\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/tn/tranpay/logger/TranLogger;", "", "()V", "DEFAULT_TAG", "", "isDebugMode", "", "logLevel", "Lcom/tn/tranpay/logger/LogLevel;", "plugins", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/tn/tranpay/logger/LoggerPlugin;", "addPlugin", "", "plugin", "debug", "message", "tag", "error", "info", "initialize", "level", "debugMode", "log", "warning", "lib_release"})
@SourceDebugExtension(value={"SMAP\nTranLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranLogger.kt\ncom/tn/tranpay/logger/TranLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1855#2,2:57\n*S KotlinDebug\n*F\n+ 1 TranLogger.kt\ncom/tn/tranpay/logger/TranLogger\n*L\n46#1:57,2\n*E\n"})
public final class TranLogger {
    @NotNull
    public static final TranLogger INSTANCE = new TranLogger();
    @NotNull
    private static LogLevel logLevel = LogLevel.INFO;
    private static boolean isDebugMode;
    @NotNull
    private static final CopyOnWriteArrayList<LoggerPlugin> plugins;
    @NotNull
    private static final String DEFAULT_TAG = "TranPay";

    private TranLogger() {
    }

    public final void initialize(@NotNull LogLevel level, boolean debugMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        logLevel = level;
        isDebugMode = debugMode;
    }

    public static /* synthetic */ void initialize$default(TranLogger tranLogger, LogLevel logLevel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = LogLevel.INFO;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        tranLogger.initialize(logLevel, bl);
    }

    public final void addPlugin(@Nullable LoggerPlugin plugin) {
        if (plugin != null) {
            plugins.add(plugin);
        } else {
            Log.e((String)DEFAULT_TAG, (String)"Attempt to add null plugin ignored");
        }
    }

    private final void log(LogLevel level, String tag, String message) {
        if (level.ordinal() < logLevel.ordinal()) {
            return;
        }
        if (isDebugMode) {
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Log.d((String)tag, (String)message);
                    break;
                }
                case 2: {
                    Log.i((String)tag, (String)message);
                    break;
                }
                case 3: {
                    Log.w((String)tag, (String)message);
                    break;
                }
                case 4: {
                    Log.e((String)tag, (String)message);
                }
            }
        }
        TranLogger tranLogger = this;
        try {
            TranLogger $this$log_u24lambda_u241 = tranLogger;
            boolean bl = false;
            Iterable $this$forEach$iv = plugins;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LoggerPlugin plugin = (LoggerPlugin)element$iv;
                boolean bl2 = false;
                LoggerPlugin loggerPlugin = plugin;
                if (loggerPlugin == null) continue;
                loggerPlugin.log(level, tag, message);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    static /* synthetic */ void log$default(TranLogger tranLogger, LogLevel logLevel, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DEFAULT_TAG;
        }
        tranLogger.log(logLevel, string2, string3);
    }

    public final void debug(@NotNull String message, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(LogLevel.DEBUG, tag, message);
    }

    public static /* synthetic */ void debug$default(TranLogger tranLogger, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = DEFAULT_TAG;
        }
        tranLogger.debug(string2, string3);
    }

    public final void info(@NotNull String message, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(LogLevel.INFO, tag, message);
    }

    public static /* synthetic */ void info$default(TranLogger tranLogger, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = DEFAULT_TAG;
        }
        tranLogger.info(string2, string3);
    }

    public final void warning(@NotNull String message, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(LogLevel.WARNING, tag, message);
    }

    public static /* synthetic */ void warning$default(TranLogger tranLogger, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = DEFAULT_TAG;
        }
        tranLogger.warning(string2, string3);
    }

    public final void error(@NotNull String message, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(LogLevel.ERROR, tag, message);
    }

    public static /* synthetic */ void error$default(TranLogger tranLogger, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = DEFAULT_TAG;
        }
        tranLogger.error(string2, string3);
    }

    static {
        plugins = new CopyOnWriteArrayList();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

