/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Window;
import androidx.appcompat.app.AppCompatActivity;
import com.tn.tranpay.BillingParams;
import com.tn.tranpay.BillingResult;
import com.tn.tranpay.Purchase;
import com.tn.tranpay.PurchasesUpdatedListener;
import com.tn.tranpay.TranPayClient;
import com.tn.tranpay.logger.TranLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0004H\u0014\u00a8\u0006\t"}, d2={"Lcom/tn/tranpay/activity/TranPayTransparentActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nTranPayTransparentActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranPayTransparentActivity.kt\ncom/tn/tranpay/activity/TranPayTransparentActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class TranPayTransparentActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXTRA_BILLING_PARAMS = "extra_billing_params";
    @NotNull
    private static final String EXTRA_CALLBACK_ID = "extra_callback_id";
    @NotNull
    private static final Map<String, PurchasesUpdatedListener> callbackMap = new LinkedHashMap();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        PurchasesUpdatedListener callback;
        String callbackId;
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        if (window != null) {
            Window window2 = window;
            boolean bl = false;
            window2.setStatusBarColor(0);
            window2.setNavigationBarColor(0);
            window2.setFlags(0x4000000, 0x4000000);
            window2.addFlags(128);
        }
        TranLogger.info$default(TranLogger.INSTANCE, "TranPayTransparentActivity: onCreate, keeping activity alive", null, 2, null);
        BillingParams params2 = (BillingParams)this.getIntent().getParcelableExtra(EXTRA_BILLING_PARAMS);
        String string = callbackId = this.getIntent().getStringExtra(EXTRA_CALLBACK_ID);
        if (string != null) {
            String it = string;
            boolean bl = false;
            v2 = callbackMap.get(it);
        } else {
            v2 = callback = null;
        }
        if (params2 != null && callback != null) {
            TranLogger.info$default(TranLogger.INSTANCE, "TranPayTransparentActivity: launching billing flow with txnId: " + params2.getTxnId(), null, 2, null);
            TranLogger.info$default(TranLogger.INSTANCE, "TranPayTransparentActivity: Ready to launch payment, will keep activity alive until callback", null, 2, null);
            PurchasesUpdatedListener wrappedCallback2 = new PurchasesUpdatedListener(callback, this){
                final /* synthetic */ PurchasesUpdatedListener $callback;
                final /* synthetic */ TranPayTransparentActivity this$0;
                {
                    this.$callback = $callback;
                    this.this$0 = $receiver;
                }

                public void onPurchasesUpdated(@NotNull BillingResult result, @Nullable Purchase purchase) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    TranLogger.info$default(TranLogger.INSTANCE, "TranPayTransparentActivity: Payment callback received, code=" + result.getResponseCode(), null, 2, null);
                    this.$callback.onPurchasesUpdated(result, purchase);
                    TranLogger.info$default(TranLogger.INSTANCE, "TranPayTransparentActivity: Payment completed, finishing activity", null, 2, null);
                    this.this$0.finish();
                }
            };
            TranPayClient.INSTANCE.launchBillingFlow(this, params2, wrappedCallback2);
        } else {
            TranLogger.error$default(TranLogger.INSTANCE, "TranPayTransparentActivity: missing params or callback", null, 2, null);
            PurchasesUpdatedListener purchasesUpdatedListener = callback;
            if (purchasesUpdatedListener != null) {
                purchasesUpdatedListener.onPurchasesUpdated(new BillingResult(-1, ""), null);
            }
            this.finish();
        }
    }

    protected void onDestroy() {
        block1: {
            String callbackId;
            super.onDestroy();
            TranLogger.error$default(TranLogger.INSTANCE, "TranPayTransparentActivity: onDestroy - This should only happen after payment callback!", null, 2, null);
            String string = callbackId = this.getIntent().getStringExtra(EXTRA_CALLBACK_ID);
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            PurchasesUpdatedListener removedCallback = callbackMap.remove(it);
            if (removedCallback != null) {
                TranLogger.warning$default(TranLogger.INSTANCE, "TranPayTransparentActivity: Callback was removed due to activity destruction!", null, 2, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/tn/tranpay/activity/TranPayTransparentActivity$Companion;", "", "()V", "EXTRA_BILLING_PARAMS", "", "EXTRA_CALLBACK_ID", "callbackMap", "", "Lcom/tn/tranpay/PurchasesUpdatedListener;", "start", "", "context", "Landroid/content/Context;", "params", "Lcom/tn/tranpay/BillingParams;", "callback", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void start(@NotNull Context context, @NotNull BillingParams params2, @NotNull PurchasesUpdatedListener callback) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            String callbackId = "" + System.currentTimeMillis() + Math.random();
            callbackMap.put(callbackId, callback);
            Intent $this$start_u24lambda_u240 = intent = new Intent(context, TranPayTransparentActivity.class);
            boolean bl = false;
            $this$start_u24lambda_u240.putExtra(TranPayTransparentActivity.EXTRA_BILLING_PARAMS, (Parcelable)params2);
            $this$start_u24lambda_u240.putExtra(TranPayTransparentActivity.EXTRA_CALLBACK_ID, callbackId);
            $this$start_u24lambda_u240.addFlags(0x10000000);
            Intent intent2 = intent;
            context.startActivity(intent2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

