/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.helper;

import android.app.Application;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.tn.tranpay.TranPay;
import com.tn.tranpay.logger.TranLogger;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/tn/tranpay/helper/NetworkUtils;", "", "()V", "getNetworkType", "", "isNetworkAvailable", "", "lib_release"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE = new NetworkUtils();

    private NetworkUtils() {
    }

    public final boolean isNetworkAvailable() {
        try {
            boolean isConnected;
            NetworkInfo activeNetworkInfo;
            ConnectivityManager connectivityManager;
            Application context = TranPay.INSTANCE.getApplication$lib_release();
            Object object = context.getSystemService("connectivity");
            ConnectivityManager connectivityManager2 = connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            if (connectivityManager == null) {
                TranLogger.warning$default(TranLogger.INSTANCE, "\u65e0\u6cd5\u83b7\u53d6 ConnectivityManager", null, 2, null);
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                boolean hasInternet;
                Network network = connectivityManager.getActiveNetwork();
                if (network == null) {
                    NetworkUtils $this$isNetworkAvailable_u24lambda_u240 = this;
                    boolean bl = false;
                    TranLogger.warning$default(TranLogger.INSTANCE, "\u7f51\u7edc\u4e0d\u53ef\u7528: activeNetwork \u4e3a null", null, 2, null);
                    return false;
                }
                Network network2 = network;
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network2);
                if (networkCapabilities == null) {
                    NetworkUtils $this$isNetworkAvailable_u24lambda_u241 = this;
                    boolean bl = false;
                    TranLogger.warning$default(TranLogger.INSTANCE, "\u7f51\u7edc\u4e0d\u53ef\u7528: NetworkCapabilities \u4e3a null", null, 2, null);
                    return false;
                }
                NetworkCapabilities capabilities = networkCapabilities;
                boolean bl = hasInternet = capabilities.hasCapability(12) && capabilities.hasCapability(16);
                if (!hasInternet) {
                    TranLogger.warning$default(TranLogger.INSTANCE, "\u7f51\u7edc\u4e0d\u53ef\u7528: \u65e0Internet\u8fde\u63a5\u6216\u672a\u9a8c\u8bc1", null, 2, null);
                }
                return hasInternet;
            }
            NetworkInfo networkInfo = activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            boolean bl = networkInfo != null ? networkInfo.isConnected() : (isConnected = false);
            if (!isConnected) {
                TranLogger.warning$default(TranLogger.INSTANCE, "\u7f51\u7edc\u4e0d\u53ef\u7528: activeNetworkInfo.isConnected = false", null, 2, null);
            }
            return isConnected;
        }
        catch (Exception e) {
            TranLogger.error$default(TranLogger.INSTANCE, "\u68c0\u67e5\u7f51\u7edc\u72b6\u6001\u5931\u8d25: " + e.getMessage(), null, 2, null);
            return true;
        }
    }

    @NotNull
    public final String getNetworkType() {
        String string2;
        try {
            String string3;
            Application context = TranPay.INSTANCE.getApplication$lib_release();
            Object object = context.getSystemService("connectivity");
            ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            if (connectivityManager == null) {
                return "UNKNOWN";
            }
            ConnectivityManager connectivityManager2 = connectivityManager;
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager2.getActiveNetwork();
                if (network == null) {
                    return "UNKNOWN";
                }
                Network network2 = network;
                NetworkCapabilities networkCapabilities = connectivityManager2.getNetworkCapabilities(network2);
                if (networkCapabilities == null) {
                    return "UNKNOWN";
                }
                NetworkCapabilities capabilities = networkCapabilities;
                string3 = capabilities.hasTransport(1) ? "WIFI" : (capabilities.hasTransport(0) ? "MOBILE" : (capabilities.hasTransport(3) ? "ETHERNET" : "UNKNOWN"));
            } else {
                Integer n;
                NetworkInfo networkInfo = connectivityManager2.getActiveNetworkInfo();
                Integer n2 = n = networkInfo != null ? Integer.valueOf(networkInfo.getType()) : null;
                int n3 = 1;
                if (n2 != null && n2 == n3) {
                    string3 = "WIFI";
                } else {
                    Integer n4 = n;
                    if (n4 != null && n4 == 0) {
                        string3 = "MOBILE";
                    } else {
                        Integer n5 = n;
                        n3 = 9;
                        string3 = n5 != null && n5 == n3 ? "ETHERNET" : "UNKNOWN";
                    }
                }
            }
            string2 = string3;
        }
        catch (Exception e) {
            TranLogger.error$default(TranLogger.INSTANCE, "\u83b7\u53d6\u7f51\u7edc\u7c7b\u578b\u5931\u8d25: " + e.getMessage(), null, 2, null);
            string2 = "UNKNOWN";
        }
        return string2;
    }
}

