/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.report;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tn.tranpay.TranPay;
import com.tn.tranpay.logger.TranLogger;
import com.tn.tranpay.report.LogViewConfig;
import com.tn.tranpay.report.ReportApi;
import com.tn.tranpay.report.ThreadSingleExecutor;
import com.transsion.athenacust.AthenaCust;
import com.transsion.ga.AthenaAnalytics;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010H\u0002J2\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001e\u0010\u0018\u001a\u00020\u00042\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010H\u0002J,\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010J$\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dJ6\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010H\u0002J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/tn/tranpay/report/Report;", "", "()V", "EXT", "", "TAG", "api", "Lcom/tn/tranpay/report/ReportApi;", "appId", "", "mLastPageName", "addToRecentEvent", "", "pageName", "event", "map", "", "initSDK", "context", "Landroid/app/Application;", "channel", "debug", "", "isHost", "map2JsonStr", "reportClick", "reportEvent", "reportPT", "logConfig", "Lcom/tn/tranpay/report/LogViewConfig;", "reportPV", "reportUIEvent", "category", "track", "bundle", "Landroid/os/Bundle;", "lib_release"})
public final class Report {
    @NotNull
    public static final Report INSTANCE = new Report();
    @NotNull
    private static final String TAG = "Report";
    @NotNull
    private static final String EXT = "ext";
    @NotNull
    private static String mLastPageName = "";
    private static int appId = 3560;
    @Nullable
    private static ReportApi api;

    private Report() {
    }

    public final void initSDK(@NotNull Application context, @NotNull String channel, boolean debug, boolean isHost, @Nullable ReportApi api) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        AthenaAnalytics.init((Context)((Context)context), (String)channel, (int)appId, (boolean)true, (boolean)isHost);
        AthenaAnalytics.setTest((boolean)debug);
        Report.api = api;
        TranLogger.INSTANCE.info("init athena debug " + debug, TAG);
    }

    public static /* synthetic */ void initSDK$default(Report report, Application application, String string2, boolean bl, boolean bl2, ReportApi reportApi, int n, Object object) {
        if ((n & 0x10) != 0) {
            reportApi = null;
        }
        report.initSDK(application, string2, bl, bl2, reportApi);
    }

    public final void reportPV(@NotNull LogViewConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Map map = logConfig.getParamsMap();
        String string2 = "page_from";
        String string3 = logConfig.getFromPageName();
        if (string3 == null) {
            string3 = mLastPageName;
        }
        String string4 = string3;
        map.put(string2, string4);
        String string5 = logConfig.getOps();
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            ((Map)logConfig.getParamsMap()).put("ops", it);
        }
        this.reportUIEvent("reportPV", logConfig.getPageName(), "pv", (Map<String, String>)logConfig.getParamsMap());
    }

    public final void reportPT(@NotNull LogViewConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Map map = logConfig.getParamsMap();
        String string2 = "page_from";
        String string3 = logConfig.getFromPageName();
        if (string3 == null) {
            string3 = mLastPageName;
        }
        String string4 = string3;
        map.put(string2, string4);
        ((Map)logConfig.getParamsMap()).put("duration", String.valueOf(SystemClock.elapsedRealtime() - logConfig.getResumeTime()));
        ((Map)logConfig.getParamsMap()).put("is_load_success", String.valueOf(logConfig.isLoadSuccess()));
        String string5 = logConfig.getOps();
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            ((Map)logConfig.getParamsMap()).put("ops", it);
        }
        this.reportUIEvent("reportPT", logConfig.getPageName(), "pt", (Map<String, String>)logConfig.getParamsMap());
        if (!TextUtils.equals((CharSequence)mLastPageName, (CharSequence)logConfig.getPageName()) && logConfig.getNeedAddToPageFrom()) {
            mLastPageName = logConfig.getPageName();
        }
    }

    public final void reportClick(@NotNull String pageName, @NotNull String event, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.reportUIEvent("reportClick", pageName, event, map);
    }

    private final void reportUIEvent(String category, String pageName, String event, Map<String, String> map) {
        ThreadSingleExecutor.Companion.getINSTANCE().execute(() -> Report.reportUIEvent$lambda$2(category, event, pageName, map));
    }

    private final void addToRecentEvent(String pageName, String event, Map<String, String> map) {
        block0: {
            ReportApi reportApi = api;
            if (reportApi == null) break block0;
            reportApi.addToRecentEvent(pageName, event, map);
        }
    }

    public final void reportEvent(@NotNull String event, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        ThreadSingleExecutor.Companion.getINSTANCE().execute(() -> Report.reportEvent$lambda$3(event, map));
    }

    private final void track(String event, Bundle bundle) {
        try {
            Application app = TranPay.INSTANCE.getApplication$lib_release();
            bundle.putString("vaid", AthenaAnalytics.getAppVAID((Context)((Context)app)));
            ReportApi reportApi = api;
            if (reportApi == null || (reportApi = reportApi.addCommonParams(event, bundle)) == null) {
                reportApi = bundle;
            }
            ReportApi commonBundle = reportApi;
            new AthenaCust(event, appId).trackCommon((Bundle)commonBundle, null).submit();
        }
        catch (Exception ignore) {
            TranLogger.INSTANCE.error("event " + event + " exception " + ignore, TAG);
        }
    }

    private final String map2JsonStr(Map<String, String> map) {
        String string2 = new JSONObject(map).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject(map).toString()");
        return string2;
    }

    private static final void reportUIEvent$lambda$2(String $category, String $event, String $pageName, Map $map) {
        Intrinsics.checkNotNullParameter((Object)$category, (String)"$category");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)$pageName, (String)"$pageName");
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        TranLogger.INSTANCE.debug($category + " event=" + $event + "  pageName=" + $pageName + " map=" + $map, TAG);
        Bundle bundle = new Bundle();
        bundle.putString("page_name", $pageName);
        String map2JsonStr = INSTANCE.map2JsonStr($map);
        bundle.putString(EXT, map2JsonStr);
        INSTANCE.track($event, bundle);
        INSTANCE.addToRecentEvent($pageName, $event, $map);
    }

    private static final void reportEvent$lambda$3(String $event, Map $map) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        TranLogger.INSTANCE.debug("reportEvent event=" + $event + " map=" + $map + " ", TAG);
        Bundle bundle = new Bundle();
        String map2JsonStr = INSTANCE.map2JsonStr($map);
        bundle.putString(EXT, map2JsonStr);
        INSTANCE.track($event, bundle);
    }
}

