/*
 * Decompiled with CFR 0.152.
 */
package com.tn.tranpay.report;

import android.app.Application;
import android.os.Bundle;
import com.tn.tranpay.TranPay;
import com.tn.tranpay.TranPayConfiguration;
import com.tn.tranpay.device.TNDeviceHelper;
import com.tn.tranpay.report.ReportApi;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\bH\u0002J.\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010H\u0016J\u0016\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tn/tranpay/report/ReportProvider;", "Lcom/tn/tranpay/report/ReportApi;", "()V", "addToLogEventSet", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "addCommonParams", "Landroid/os/Bundle;", "event", "bundle", "addEventCommonParams", "", "addToRecentEvent", "pageName", "map", "", "getAccount", "Lkotlin/Pair;", "", "getAppVersion", "lib_release"})
public final class ReportProvider
implements ReportApi {
    @NotNull
    private HashSet<String> addToLogEventSet = new HashSet();

    public ReportProvider() {
        this.addToLogEventSet.add("app_start");
        this.addToLogEventSet.add("app_stop");
    }

    @Override
    @NotNull
    public Bundle addCommonParams(@NotNull String event, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.addEventCommonParams(bundle);
        return bundle;
    }

    @Override
    public void addToRecentEvent(@NotNull String pageName, @NotNull String event, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
    }

    @Override
    @Nullable
    public Pair<Short, String> getAccount() {
        return null;
    }

    private final void addEventCommonParams(Bundle bundle) {
        bundle.putString("device_id", TNDeviceHelper.INSTANCE.getDeviceId());
        bundle.putString("app_id", TranPayConfiguration.INSTANCE.getAppKey());
        bundle.putString("channel", TranPayConfiguration.INSTANCE.getChannel());
        bundle.putString("app_version", this.getAppVersion());
        bundle.putString("sdk_version", TranPay.INSTANCE.getSDKVersion());
        String string2 = TranPayConfiguration.INSTANCE.getCpId();
        if (string2 == null) {
            string2 = "";
        }
        bundle.putString("m_id", string2);
        String string3 = TranPayConfiguration.INSTANCE.getPayOrderId();
        if (string3 == null) {
            string3 = "";
        }
        bundle.putString("pay_order_id", string3);
        String string4 = TranPayConfiguration.INSTANCE.getTxnId();
        if (string4 == null) {
            string4 = "";
        }
        bundle.putString("txn_id", string4);
        String string5 = TranPayConfiguration.INSTANCE.getCountry();
        if (string5 == null) {
            string5 = "";
        }
        bundle.putString("country", string5);
        String string6 = TranPayConfiguration.INSTANCE.getCurrency();
        if (string6 == null) {
            string6 = "";
        }
        bundle.putString("currency", string6);
        String string7 = TranPayConfiguration.INSTANCE.getAmount();
        if (string7 == null) {
            string7 = "";
        }
        bundle.putString("amount", string7);
        bundle.putString("timestamp", String.valueOf(System.currentTimeMillis()));
    }

    private final String getAppVersion() {
        String string2;
        try {
            Application app = TranPay.INSTANCE.getApplication$lib_release();
            String string3 = app.getPackageManager().getPackageInfo((String)app.getPackageName(), (int)0).versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            // \u4f7f\u7528 Tran\u2026 0).versionName\n        }");
            string2 = string3;
        }
        catch (Exception e) {
            string2 = "unknown";
        }
        return string2;
    }
}

