package com.transsion.version.update.dialog

import android.app.Dialog
import android.content.Context
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.WindowManager
import com.blankj.utilcode.constant.MemoryConstants
import com.blankj.utilcode.util.ConvertUtils
import com.tn.lib.logger.MBLogger
import com.transsion.baseui.dialog.BaseNativeDialog
import com.transsion.baseui.utils.AppUtil
import com.transsion.version.update.R
import com.transsion.version.update.databinding.DialogUpdateLayoutWhiteThemeBinding
import com.transsion.version.update.RemoteVersionInfo
import com.transsion.version.update.UpdateManager

class UpdateNativeDialog(
    context: Context,
    private val manual: Boolean
) :
    BaseNativeDialog(context, R.style.BottomDialogTheme) {

    private val viewBinding =
        DialogUpdateLayoutWhiteThemeBinding.inflate(LayoutInflater.from(context), null, false)
    private var onUpdateClick: ((Boolean) -> Unit)? = null
    var updateVersionName: String = ""
        private set

    private var remoteVersionInfo: RemoteVersionInfo? = null

    init {
        setContentView(viewBinding.root)
        setCanceledOnTouchOutside(false)
        window?.let { dialogWindow ->
            dialogWindow.setGravity(Gravity.BOTTOM)
            dialogWindow.setDimAmount(0.5f)
            val lp = dialogWindow.attributes ?: WindowManager.LayoutParams()
            lp.width = AppUtil.getWidth(context)
            lp.height = WindowManager.LayoutParams.WRAP_CONTENT
            dialogWindow.setBackgroundDrawable(null)
            dialogWindow.attributes = lp
        }
        setOnDismissListener { onDestroy() }
        setupClickListeners()
    }

    private fun setupClickListeners() {
        viewBinding.btSkip.setOnClickListener {
            dismiss()
            onUpdateClick?.invoke(false)
        }
        viewBinding.btUpdate.setOnClickListener {
            val forceUpdate = remoteVersionInfo?.forceUpdate == true
            if (!forceUpdate) {
                dismiss()
            }
            onUpdateClick?.invoke(true)
        }
    }

    fun setOnUpdateClick(callback: (Boolean) -> Unit) {
        this.onUpdateClick = callback
    }

    fun setRemoteVersionInfo(versionInfo: RemoteVersionInfo?) {
        remoteVersionInfo = versionInfo
        bindVersionInfo(versionInfo)
    }

    private fun bindVersionInfo(versionInfo: RemoteVersionInfo?) {
        val forceUpdate = versionInfo?.forceUpdate == true
        val title = versionInfo?.noticeConfig?.updateTitle
        val desc = versionInfo?.noticeConfig?.updateDesc
        val pkgSize = versionInfo?.installPkgSize ?: 0
        ConvertUtils.memorySize2Byte(pkgSize, MemoryConstants.MB)
        updateVersionName = versionInfo?.noticeConfig?.updateVersionName ?: ""

        viewBinding.tvVersion.text =
            context.getString(R.string.version, updateVersionName)
        if (!title.isNullOrEmpty()) {
            viewBinding.tvTitle.text = title
        }
        if (!desc.isNullOrEmpty()) {
            viewBinding.tvDetails.text = desc
        }
        setCancelable(!forceUpdate)
        setCanceledOnTouchOutside(!forceUpdate)
        viewBinding.btSkip.visibility = if (forceUpdate) View.GONE else View.VISIBLE
    }

    companion object {
        fun create(
            context: Context,
            remoteVersionInfo: RemoteVersionInfo,
            manual: Boolean,
            callback: (Boolean) -> Unit
        ): UpdateNativeDialog {
            return UpdateNativeDialog(context, manual).apply {
                setRemoteVersionInfo(remoteVersionInfo)
                setOnUpdateClick(callback)
            }
        }
    }

    override fun bypassSessionNoLimit(): Boolean {
        // 手动触发的弹窗，不绕过会话限制
        if (manual) {
            return true
        }
        MBLogger.d("被弹窗拦截策略拦截 $this")
        return false
    }

    override fun onShow() {
        super.onShow()
        if (manual) return
        UpdateManager.getInstance().saveShowInfo(updateVersionName)
    }
}

