package com.transsion.version.update

import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.parcelize.Parcelize

@Keep
@Parcelize
data class RemoteVersionInfo(
    val hasUpdate: Boolean = false, //是否有更新
    val forceUpdate: Boolean = false,  //是否为强制更新
    val patchUrl: String,   //增量包下载地址
    val patchMd5: String,   //增量包md5
    val patchSize: Long,    //增量包大小
    val installPkgUrl: String,  //安装包下载地址
    val installPkgVersionCode: Long,    //安装包版本号
    val installPkgMd5: String,  //安装包md5
    val installPkgSize: Long,   //安装包大小
    val updateType: String = UPDATETYPE_STORE,    //更新类型  store: 应用商店更新; direct: 原差分策略;
    val appStoreUrl: String = "",    //应用商店下载地址
    val webDownloadUrl: String = "",    //网页下载地址
    val noticeConfig: NoticeConfig? = null,     //升级通知配置
) : Parcelable

val UPDATETYPE_STORE = "store"
val UPDATETYPE_DIRECT = "direct"

@Keep
@Parcelize
data class NoticeConfig(
    val notifyTimes: Int = 3,//提醒次数。同一升级目标内的弹窗次数
    val notifyInterval: Float,//提醒间隔  单位/h
    val silentPolicy: String, // 0:wifi静默下载；1 全网络环境静默下载
    val updateDesc: String,//升级描述
    val updateTitle: String,//升级标题
    val updateVersionCode: Int,//升级的目标版本。提醒次数
    val updateVersionName: String,//升级的目标版本名。

) : Parcelable

