package com.transsion.version.update

import android.app.Activity
import android.os.Build
import android.text.TextUtils
import com.blankj.utilcode.util.AppUtils
import com.blankj.utilcode.util.Utils
import com.tn.lib.logger.MBLogger
import com.tn.lib.net.cons.HeaderConst
import com.tn.lib.net.utils.MkvHeader
import com.transsion.upgradesdk.manager.UpgradeSdkManager
import com.transsion.version.update.dialog.UpdateConfig

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2025/7/3 12:15
 *
 *   Desc
 */
class UpdateManager {


    companion object {

        const val TAG: String = "update"

        @Volatile
        private var INSTANCE: UpdateManager? = null

        fun getInstance(): UpdateManager {
            // 单例
            return INSTANCE ?: synchronized(this) {
                val instance = UpdateManager()
                INSTANCE = instance
                instance
            }
        }
    }

    var updateVersionRequest: UpdateVersionRequest? = null

    init {
        updateVersionRequest = UpdateVersionRequest()
    }

    //目标版本大于当前存的版本
    fun isNewVersionReady(): Boolean {
        val targetCode = UpdateMMKV.mmkv.getInt(UpdateConfig.TARGET_VERSION_CODE, 0)
        return targetCode > AppUtils.getAppVersionCode()
    }


    fun init(appKey: String) {
        if (deviceTranssion()) {
            UpgradeSdkManager.getInstance()
                .init(Utils.getApp(), "4ae48db34940e5375db0741f7f86d494", false)
        }
    }


    /**
     * 开始 检查 是否有更新
     * @param context Context
     * @param fromPage String
     */
    fun startCheckUpdate(
        activity: Activity,
        fromPage: String,
        callback: ((noNeedUpdate: Boolean?) -> Unit)? = null,
        appPath: String,
        appName: String,
        manual: Boolean = false
    ) {
        updateVersionRequest?.startCheckUpdate(
            activity,
            fromPage,
            callback,
            appPath,
            appName = appName,
            manual
        )
        checkVersionUpdate()
    }


//    /**
//     * 开始弹出升级弹窗.手动唤起
//     * @param context Context
//     * @param fromPage String
//     * @param manual Boolean  手动唤起 不累计展示次数
//     */
//    fun startUpdateDialogByUser(activity: Activity, fromPage: String, manual: Boolean = true) {
//        updateVersionRequest?.startUpdateProcess(activity, fromPage, manual)
//    }

    // 假设在检查版本更新的方法中添加以下逻辑
    fun checkVersionUpdate() {

        // 检测到新版本已安装
        val lastVersion = UpdateMMKV.mmkv.getInt(UpdateConstants.KEY_LAST_INSTALLED_VERSION, 0)
        val userClickedDialogType =
            UpdateMMKV.mmkv.getString(UpdateConstants.KEY_USER_CLICKED_DIALOG_TYPE, "")
        val updateSuccess = isNewVersionInstalled() && userClickedDialogType?.isNotEmpty() == true
        MBLogger.d(TAG, "updateSuccess $updateSuccess")
        if (updateSuccess) {
            // 清除点击记录，避免重复标记
            UpdateMMKV.mmkv.remove(UpdateConstants.KEY_USER_CLICKED_DIALOG_TYPE)
            UpdateReport.reportEventStage(
                mapOf(
                    "action" to "update_success",
                    "last_version" to lastVersion.toString(),
                    "dialog_type" to userClickedDialogType,
                )
            )

        }
    }

    // 判断是否安装了新版本的辅助方法
    private fun isNewVersionInstalled(): Boolean {
        val lastVersion = UpdateMMKV.mmkv.getInt(UpdateConstants.KEY_LAST_INSTALLED_VERSION, 0)
        val currentVersionCode = AppUtils.getAppVersionCode()
        val isNewVersion = lastVersion != 0 && lastVersion < currentVersionCode
        if (isNewVersion) {
            UpdateMMKV.mmkv.putInt(UpdateConstants.KEY_LAST_INSTALLED_VERSION, currentVersionCode)
        }
        return isNewVersion
    }


    fun saveShowInfo(showedTargetAppVersionName: String?) {
        //已展示版本
        UpdateMMKV.mmkv.putString(
            UpdateConfig.SHOWED_TARGET_VERSION_NAME,
            showedTargetAppVersionName
        )
        //已展示次数
        var showedTimes = UpdateMMKV.mmkv.getInt(UpdateConfig.UPDATE_DIALOG_SHOWED_TIMES, 0)
        UpdateMMKV.mmkv.putInt(UpdateConfig.UPDATE_DIALOG_SHOWED_TIMES, showedTimes + 1)
        //已展示时间戳
        UpdateMMKV.mmkv.putLong(
            UpdateConfig.UPDATE_DIALOG_SHOW_TIMESTAMP,
            System.currentTimeMillis()
        )
    }



    /**
     * 是否是Transsion设备
     */


    private val BRAND_TECNO = "TECNO"
    private val BRAND_INFINIX = "INFINIX"
    private val BRAND_ITEL = "ITEL"
    private val TRANSSION_DEVICE = hashSetOf(BRAND_TECNO, BRAND_INFINIX, BRAND_ITEL)

    fun deviceTranssion(): Boolean {
        var brand = MkvHeader.netMmkv?.getString(HeaderConst.PHONE_BRAND, "") ?: ""
        if (TextUtils.isEmpty(brand)) {
            brand = Build.BRAND
        }
        MBLogger.d(TAG, "brand $brand")
        val uppercase = brand.uppercase()
        val findBrand = TRANSSION_DEVICE.find {
            it.startsWith(uppercase)
        }
        return findBrand != null
    }


}