package com.transsion.version.update

import android.util.Log
import com.blankj.utilcode.util.AppUtils
import com.transsion.base.report.athena.Report

object UpdateReport {
    const val TAG = "UpdateReport"
    private const val pageName = "update_page"

    /**
     * action 代表阶段不同
     *  check  --手动检查更新
     * 1. show_dialog
     * 2. click
     * 3. jump
     * 4. update_success
     */


    fun showDialog(
        fromPage: String,
        manual: Boolean,
        dialogType: String,
        errorMsg: String? = null
    ) {
        val map = mutableMapOf<String, String>()
        Log.d(TAG, "show diffUpdateDialog from page:$fromPage, $map")
        map["action"] = "show_dialog"
        map["page_from"] = fromPage
        map["manual"] = manual.toString()
        map["dialog_type"] = dialogType
        map["ps_error_msg"] = errorMsg.toString()
        Report.reportUIEvent(pageName, "update", map)
    }

    fun clickDialogButton(fromPage: String, isUpgrade: Boolean, dialogType: String) {
        val map = mutableMapOf<String, String>()
        map["is_upgrade"] = isUpgrade.toString()
        map["dialog_type"] = dialogType
        map["action"] = "click"
        map["page_from"] = fromPage
        Report.reportUIEvent(pageName, "update", map)
        if (isUpgrade) {
            // 记录用户点击升级按钮行为
            UpdateMMKV.mmkv.putString(UpdateConstants.KEY_USER_CLICKED_DIALOG_TYPE, dialogType)
            UpdateMMKV.mmkv.putInt(
                UpdateConstants.KEY_LAST_INSTALLED_VERSION,
                AppUtils.getAppVersionCode()
            )
        }
    }

    fun reportEventStage(map: Map<String, String?>) {
        Report.reportUIEvent(pageName, "update", map)
    }

}