package com.transsion.version.update.dialog

import android.app.Dialog
import android.os.Bundle
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import androidx.fragment.app.FragmentManager
import com.blankj.utilcode.constant.MemoryConstants
import com.blankj.utilcode.util.ConvertUtils
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.tn.lib.logger.MBLogger
import com.transsion.baseui.dialog.BaseDialog
import com.transsion.baseui.utils.AppUtil
import com.transsion.version.update.R
import com.transsion.version.update.databinding.DialogUpdateLayoutBinding
import com.transsion.version.update.RemoteVersionInfo
import com.transsion.version.update.UpdateManager

class UpdateDialog(private val manual: Boolean) :
    BaseDialog(R.layout.dialog_update_layout_white_theme) {
    private var viewBinding: DialogUpdateLayoutBinding? = null
    private var onUpdateClick: ((Boolean) -> Unit)? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NORMAL, R.style.BottomDialogTheme)
        // 切换主题后 callback 无法恢复，所以这里选择直接关闭弹窗
        if (null != savedInstanceState) {
            dismissAllowingStateLoss()
        }
    }

    fun setOnUpdateClick(callback: (Boolean) -> Unit) {
        this.onUpdateClick = callback
    }

    private var remoteVersionInfo: RemoteVersionInfo? = null
    var updateVersionName = ""
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        viewBinding = DialogUpdateLayoutBinding.bind(view)
        val forceUpdate = remoteVersionInfo?.forceUpdate == true
        val title = remoteVersionInfo?.noticeConfig?.updateTitle
        val desc = remoteVersionInfo?.noticeConfig?.updateDesc
        val pkgSize = remoteVersionInfo?.installPkgSize ?: 0
        val pkgSizeMB = ConvertUtils.memorySize2Byte(pkgSize, MemoryConstants.MB)
        val updateVersionCode = remoteVersionInfo?.noticeConfig?.updateVersionCode ?: 0


        //设置相关文案
        viewBinding?.tvVersion?.text = context?.getString(R.string.version, updateVersionName)
        if (!title.isNullOrEmpty()) {
            viewBinding?.tvTitle?.text = title
        }
        if (!desc.isNullOrEmpty()) {
            viewBinding?.tvDetails?.text = desc
        }
        //处理强制升级弹窗 不能被取消
        dialog?.setCancelable(!forceUpdate)
        dialog?.setCanceledOnTouchOutside(!forceUpdate)

        //强制升级隐藏跳过
        viewBinding?.btSkip?.visibility = if (forceUpdate) View.GONE else View.VISIBLE
        viewBinding?.btSkip?.setOnClickListener() {
            dismissAllowingStateLoss()
            onUpdateClick?.invoke(false)
        }

        viewBinding?.btUpdate?.setOnClickListener() {
            if (!forceUpdate) {
                dismissAllowingStateLoss()
            }
            onUpdateClick?.invoke(true)
        }

    }


    override fun onResume() {
        super.onResume()
    }

    override fun show(manager: FragmentManager, tag: String?) {
        super.show(manager, tag)

    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val ctx = requireContext()
        val dialog: Dialog = BottomSheetDialog(ctx, theme)
        dialog.setCanceledOnTouchOutside(false)
        dialog.window?.let {
            it.setGravity(Gravity.CENTER)
            it.setDimAmount(0.5f)
            val lp = it.attributes ?: WindowManager.LayoutParams()
            lp.width = AppUtil.getWidth(ctx)
            it.setBackgroundDrawable(null)
            it.attributes = lp
        }
        return dialog
    }

    fun setRemoteVersionInfo(versionInfo: RemoteVersionInfo?) {
        remoteVersionInfo = versionInfo
        updateVersionName = remoteVersionInfo?.noticeConfig?.updateVersionName ?: ""

    }

    companion object {
        fun newInstance(
            remoteVersionInfo: RemoteVersionInfo,
            manual: Boolean,
            callback: (Boolean) -> Unit
        ): UpdateDialog {
            return UpdateDialog(manual).apply {
                arguments = Bundle().apply {
                    putParcelable("remoteVersionInfo", remoteVersionInfo)
                }
                setRemoteVersionInfo(remoteVersionInfo)
                setOnUpdateClick(callback)
            }
        }
    }

    override fun bypassSessionNoLimit(): Boolean {
        // 手动触发的弹窗，不绕过会话限制
        if (manual) {
            return true
        }
        MBLogger.d(UpdateManager.TAG, "被弹窗拦截策略拦截 $this")
        return false
    }

    override fun onShow() {
        super.onShow()
        if (manual) return
        UpdateManager.getInstance().saveShowInfo(updateVersionName)
    }


}




