package com.transsion.version.update.ps

import android.app.Activity
import com.tn.lib.logger.MBLogger
import com.transsion.baseui.dialog.DialogSessionManager
import com.transsion.upgradesdk.bean.BUTTON_TYPE
import com.transsion.upgradesdk.bean.UpgradeInfo
import com.transsion.upgradesdk.manager.UpgradeDialogCallback
import com.transsion.upgradesdk.manager.UpgradeInfoCallback
import com.transsion.upgradesdk.manager.UpgradeSdkManager
import com.transsion.version.update.UpdateConstants
import com.transsion.version.update.UpdateManager
import com.transsion.version.update.UpdateReport

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2025/6/26 19:34
 *
 *   Desc
 */
object PsUpdateUtils {


    /**
     * 1. 调起优先对应页面
     *
     * 2. 如果失败调起
     */
    fun showUpdateDialog(
        fromPage: String,
        manual: Boolean,
        activity: Activity,
        configVersionName: String,
        callback: ((errorMsg: String) -> Unit)? = null
    ) {
        if (!manual && DialogSessionManager.hasShownAnyDialogInSession) {
            MBLogger.e(UpdateManager.TAG, "ps 弹窗被拦截  $fromPage")
            return
        }
        UpgradeSdkManager.getInstance().checkUpgradeTask(object : UpgradeInfoCallback {
            override fun onRequestFail(error: String) {
                MBLogger.e(UpdateManager.TAG, "ps onRequestFail $error")
                callback?.invoke(error)
            }

            override fun onRequestSuccess(upgradeInfo: UpgradeInfo) {
                MBLogger.e(
                    UpdateManager.TAG,
                    "onRequestSuccess ${upgradeInfo.versionName} ${upgradeInfo.isNewVersion} ${upgradeInfo.showUpgradeDialog} ${upgradeInfo}"
                )
                if (upgradeInfo.showUpgradeDialog) {
                    UpgradeSdkManager.getInstance()
                        .showUpgradeDialog(activity, true, object : UpgradeDialogCallback {
                            override fun onDialogClick(buttonType: Int) {
                                MBLogger.e(UpdateManager.TAG, "ps_dialog buttonType $buttonType")
                                if (buttonType == BUTTON_TYPE.TYPE_UPDATE) {
                                    UpdateReport.clickDialogButton(
                                        fromPage,
                                        true,
                                        UpdateConstants.DIALOG_TYPE_PS
                                    )
                                    UpdateReport.reportEventStage(
                                        mapOf(
                                            "action" to "jump",
                                            "action_result" to "true",
                                            "dialog_type" to UpdateConstants.DIALOG_TYPE_PS,
                                            "type" to "store",
                                            "manual" to manual.toString(),
                                            "page_from" to fromPage
                                        )
                                    )
                                } else {
                                    UpdateReport.clickDialogButton(
                                        fromPage,
                                        false,
                                        UpdateConstants.DIALOG_TYPE_PS
                                    )
                                }
                            }

                            override fun onDialogDismiss() {
                                MBLogger.e(UpdateManager.TAG, "ps_dialog onDialogDismiss")
                            }

                            override fun onDialogShow() {
                                UpdateReport.showDialog(
                                    fromPage,
                                    manual,
                                    UpdateConstants.DIALOG_TYPE_PS
                                )
                                if (!manual) {
                                    UpdateManager.getInstance()
                                        .saveShowInfo(configVersionName)
                                }
                                MBLogger.e(UpdateManager.TAG, "ps_dialog onDialogShow")

                            }
                        })
                } else {
                    callback?.invoke("showUpgradeDialog false")
                }
            }
        })


    }
}

