package com.transsion.version.update.store

import android.content.Context
import android.content.Intent
import androidx.core.net.toUri
import com.transsion.version.update.RemoteVersionInfo
import com.transsion.version.update.UpdateConstants
import com.transsion.version.update.UpdateReport

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2025/6/26 19:34
 *
 *   Desc
 */
class StoreUpdateStrategy {

    /**
     * 1. 调起优先对应页面
     *
     * 2. 如果失败调起
     */
    fun openAppStore(
        fromPage: String,
        context: Context?,
        remoteVersionInfo: RemoteVersionInfo?
    ): Boolean {
        val appStoreUrl = remoteVersionInfo?.appStoreUrl
        val webDownloadUrl = remoteVersionInfo?.webDownloadUrl
        var res = false
        var type = 0
        try {
            val playStoreIntent = Intent(Intent.ACTION_VIEW, appStoreUrl?.toUri())
            playStoreIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            if (context?.packageManager?.let { playStoreIntent.resolveActivity(it) } != null) {
                context.startActivity(playStoreIntent)
                res = true
            } else {
                type = 1
                res = openInChrome(context, webDownloadUrl)
            }
        } catch (e: Exception) {
            e.printStackTrace()
            type = 1
            res = openInChrome(context, webDownloadUrl)
        }
        val map = mutableMapOf<String, String>()
        map["action"] = "jump"
        map["store_uri"] = appStoreUrl ?: ""
        map["web_uri"] = webDownloadUrl ?: ""
        map["action_result"] = res.toString()
        map["type"] = if (type == 0) "store" else "web"
        map["page_from"] = fromPage
        map["dialog_type"] = UpdateConstants.DIALOG_TYPE_MB
        UpdateReport.reportEventStage(map)
        return res
    }

    private fun openInChrome(context: Context?, webDownloadUrl: String?): Boolean {
        try {
            val webIntent = Intent(Intent.ACTION_VIEW, webDownloadUrl?.toUri())
            webIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            context?.startActivity(webIntent)
        } catch (e: Exception) {
            e.printStackTrace()
            return false
        }
        return true
    }
}