package com.transsion.baseui.utils

import com.blankj.utilcode.constant.MemoryConstants
import java.util.Locale


//保留小数分开，用于速度
fun byte2FitMemorySize(byteSize: Long, mbPrecision: Int, kbPrecision: Int): String {
    return when {
        byteSize < 0 -> {
            throw IllegalArgumentException("byteSize shouldn't be less than zero!")
        }
        byteSize < MemoryConstants.KB -> {
            String.format(Locale.ENGLISH, "%." + kbPrecision + "fB", byteSize.toDouble())
        }
        byteSize < MemoryConstants.MB -> {
            String.format(Locale.ENGLISH, "%." + kbPrecision + "fKB", byteSize.toDouble() / MemoryConstants.KB)
        }
        byteSize < MemoryConstants.GB -> {
            String.format(Locale.ENGLISH, "%." + mbPrecision + "fMB", byteSize.toDouble() / MemoryConstants.MB)
        }
        else -> {
            String.format(Locale.ENGLISH, "%." + mbPrecision + "fGB", byteSize.toDouble() / MemoryConstants.GB)
        }
    }
}

fun formatDownloadMinAndSec(seconds: Int): String {
    val h = seconds / 3600
    val space = seconds % 3600
    val min = space / 60
    val sec = seconds % 60
    val sb = StringBuilder()
    if (h > 0) {
        sb.append(h).append(" h ")
    }
    if (min > 0) {
        sb.append(min).append(" min ")
    }
    if (sec > 0) {
        sb.append(sec).append(" sec")
    }
    return sb.toString()
}