/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.networkinfo;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.core.content.ContextCompat;
import com.blankj.utilcode.util.Utils;
import com.tn.lib.util.networkinfo.NetworkType;
import com.tn.lib.util.networkinfo.NetworkUtil;
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 22\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0014\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\bH\u0016J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0010H\u0002J\b\u0010*\u001a\u00020\u0010H\u0002J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010.\u001a\u00020\u000eH\u0003J\b\u00100\u001a\u00020\u0010H\u0002J\u0014\u00101\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tn/lib/util/networkinfo/NetWorkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "<init>", "()V", "mListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/tn/lib/util/networkinfo/OnNetworkStatusChangedListener;", "isConnected", "", "Ljava/lang/Boolean;", "isValidated", "getClassTag", "", "mNetworkType", "Lcom/tn/lib/util/networkinfo/NetworkType;", "registerNetworkCallback", "", "unregisterNetworkCallback", "registerNetworkStatusChangedListener", "listener", "unregisterNetworkStatusChangedListener", "getNetState", "", "getNetworkType", "onLost", "network", "Landroid/net/Network;", "onCapabilitiesChanged", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "onAvailable", "onLinkPropertiesChanged", "linkProperties", "Landroid/net/LinkProperties;", "onBlockedStatusChanged", "blocked", "onLosing", "maxMsToLive", "onUnavailable", "reset", "lostRunnable", "Lkotlin/Function0;", "disposeOnLost", "disposeConnect", "disposeValidated", "disposeNetType", "getNetTypeMobile", "timerRunnable", "startTimer", "logNetWorkType", "Companion", "utils_psRelease"})
@SourceDebugExtension(value={"SMAP\nNetWorkCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetWorkCallback.kt\ncom/tn/lib/util/networkinfo/NetWorkCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,521:1\n1869#2,2:522\n1869#2,2:524\n1869#2,2:526\n*S KotlinDebug\n*F\n+ 1 NetWorkCallback.kt\ncom/tn/lib/util/networkinfo/NetWorkCallback\n*L\n307#1:522,2\n325#1:524,2\n372#1:526,2\n*E\n"})
public final class NetWorkCallback
extends ConnectivityManager.NetworkCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CopyOnWriteArrayList<OnNetworkStatusChangedListener> mListeners = new CopyOnWriteArrayList();
    @Nullable
    private volatile Boolean isConnected;
    @Nullable
    private volatile Boolean isValidated;
    @Nullable
    private NetworkType mNetworkType;
    @NotNull
    private final Function0<Unit> lostRunnable = () -> NetWorkCallback.lostRunnable$lambda$6(this);
    @NotNull
    private final Function0<Unit> timerRunnable = () -> NetWorkCallback.timerRunnable$lambda$11(this);
    @NotNull
    private static final String TAG = "net_log";
    @NotNull
    private static final Lazy<Handler> mHandler$delegate = LazyKt.lazy(NetWorkCallback::mHandler_delegate$lambda$13);
    @NotNull
    private static final Lazy<NetWorkCallback> INSTANCE$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, NetWorkCallback::INSTANCE_delegate$lambda$14);

    private final String getClassTag() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    public final void registerNetworkCallback() {
        ConnectivityManager connMgr;
        Application application = Utils.getApp();
        Object object = application != null && (application = application.getApplicationContext()) != null ? application.getSystemService("connectivity") : null;
        ConnectivityManager connectivityManager = connMgr = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager != null) {
            connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().build(), (ConnectivityManager.NetworkCallback)this);
        }
        this.startTimer();
    }

    public final void unregisterNetworkCallback() {
        ConnectivityManager connMgr;
        Application application = Utils.getApp();
        Object object = application != null && (application = application.getApplicationContext()) != null ? application.getSystemService("connectivity") : null;
        ConnectivityManager connectivityManager = connMgr = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager != null) {
            connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
        }
        this.reset();
        this.mListeners.clear();
        Companion.getMHandler().removeCallbacksAndMessages(null);
    }

    public final void registerNetworkStatusChangedListener(@Nullable OnNetworkStatusChangedListener listener) {
        block1: {
            OnNetworkStatusChangedListener onNetworkStatusChangedListener = listener;
            if (onNetworkStatusChangedListener == null) break block1;
            OnNetworkStatusChangedListener it = onNetworkStatusChangedListener;
            boolean bl = false;
            if (!this.mListeners.contains(listener)) {
                this.mListeners.add(it);
            }
        }
    }

    public final void unregisterNetworkStatusChangedListener(@Nullable OnNetworkStatusChangedListener listener) {
        block0: {
            OnNetworkStatusChangedListener onNetworkStatusChangedListener = listener;
            if (onNetworkStatusChangedListener == null) break block0;
            OnNetworkStatusChangedListener it = onNetworkStatusChangedListener;
            boolean bl = false;
            this.mListeners.remove(it);
        }
    }

    public final int getNetState() {
        return this.isConnected() && this.isValidated() ? 2 : (this.isConnected() ? 1 : (!this.isConnected() ? 0 : 3));
    }

    public final boolean isConnected() {
        if (this.isConnected != null) {
            if (Intrinsics.areEqual((Object)this.isConnected, (Object)false)) {
                Application application = Utils.getApp();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
                return NetworkUtil.INSTANCE.isNetworkConnected((Context)application);
            }
            return Intrinsics.areEqual((Object)this.isConnected, (Object)true);
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        return NetworkUtil.INSTANCE.isNetworkConnected((Context)application);
    }

    private final boolean isValidated() {
        if (this.isValidated != null) {
            return Intrinsics.areEqual((Object)this.isValidated, (Object)true);
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        return NetworkUtil.INSTANCE.isNetworkCapability((Context)application);
    }

    @Nullable
    public final NetworkType getNetworkType() {
        if (this.mNetworkType != null) {
            return this.mNetworkType;
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        if (NetworkUtil.INSTANCE.isWifiConnected((Context)application)) {
            this.mNetworkType = NetworkType.NETWORK_WIFI;
            return this.mNetworkType;
        }
        this.mNetworkType = this.getNetTypeMobile();
        return this.mNetworkType;
    }

    public void onLost(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onLost(network);
        this.disposeOnLost();
    }

    public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
        super.onCapabilitiesChanged(network, networkCapabilities);
        try {
            boolean bl = false;
            this.disposeConnect(network, networkCapabilities);
            this.disposeValidated(networkCapabilities);
            this.disposeNetType(networkCapabilities);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Log.e((String)TAG, (String)(this.getClassTag() + " --> it = " + it));
        }
    }

    public void onAvailable(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onAvailable(network);
    }

    public void onLinkPropertiesChanged(@NotNull Network network, @NotNull LinkProperties linkProperties) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)linkProperties, (String)"linkProperties");
        super.onLinkPropertiesChanged(network, linkProperties);
    }

    public void onBlockedStatusChanged(@NotNull Network network, boolean blocked) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onBlockedStatusChanged(network, blocked);
    }

    public void onLosing(@NotNull Network network, int maxMsToLive) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onLosing(network, maxMsToLive);
    }

    public void onUnavailable() {
        super.onUnavailable();
    }

    private final void reset() {
        this.isConnected = false;
        this.isValidated = false;
        this.mNetworkType = null;
    }

    private final void disposeOnLost() {
        Companion.getMHandler().removeCallbacks(() -> NetWorkCallback.disposeOnLost$lambda$7(this.lostRunnable));
        Companion.getMHandler().postDelayed(() -> NetWorkCallback.disposeOnLost$lambda$8(this.lostRunnable), 1000L);
    }

    private final void disposeConnect(Network network, NetworkCapabilities networkCapabilities) {
        if (networkCapabilities.hasCapability(12)) {
            if (Intrinsics.areEqual((Object)this.isConnected, (Object)true)) {
                return;
            }
            this.isConnected = true;
            Log.i((String)TAG, (String)(this.getClassTag() + " --> onCapabilitiesChanged --> disposeConnect --> \u8868\u793a\u662f\u5426\u8fde\u63a5\u4e0a\u4e86\u4e92\u8054\u7f51\uff08\u4e0d\u5173\u5fc3\u662f\u5426\u53ef\u4ee5\u4e0a\u7f51"));
            Companion.getMHandler().post(() -> NetWorkCallback.disposeConnect$lambda$10(this, network, networkCapabilities));
        }
    }

    private final void disposeValidated(NetworkCapabilities networkCapabilities) {
        this.isValidated = Build.VERSION.SDK_INT >= 23 ? Boolean.valueOf(networkCapabilities.hasCapability(16)) : Boolean.valueOf(true);
        Log.i((String)TAG, (String)(this.getClassTag() + " --> disposeValidated() --> isValidated = " + this.isValidated + " netState = " + this.getNetState()));
    }

    private final void disposeNetType(NetworkCapabilities networkCapabilities) {
        NetworkType networkType;
        NetworkType networkType2 = networkCapabilities.hasTransport(1) ? NetworkType.NETWORK_WIFI : (networkType = networkCapabilities.hasTransport(0) ? this.getNetTypeMobile() : NetworkType.NETWORK_UNKNOWN);
        if (this.mNetworkType == networkType) {
            return;
        }
        this.mNetworkType = networkType;
        Log.i((String)TAG, (String)("\u5f53\u524d\u7f51\u7edc\u7c7b\u578b\u662f mNetworkType = " + (Object)((Object)this.mNetworkType)));
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"MissingPermission"})
    private final NetworkType getNetTypeMobile() {
        block5: {
            block6: {
                block9: {
                    block11: {
                        block10: {
                            block8: {
                                block7: {
                                    block4: {
                                        type = null;
                                        if (Build.VERSION.SDK_INT >= 24) break block4;
                                        type = NetworkUtil.INSTANCE.getNetworkType();
                                        break block5;
                                    }
                                    if (ContextCompat.checkSelfPermission((Context)((Context)Utils.getApp()), (String)"android.permission.READ_PHONE_STATE") != 0) break block6;
                                    v0 = telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
                                    v1 = var3_3 = v0 != null ? Integer.valueOf(v0.getDataNetworkType()) : null;
                                    var4_4 = 1;
                                    if (v1 != null && v1 == var4_4) break block7;
                                    v2 = var3_3;
                                    var4_4 = 2;
                                    if (v2 != null && v2 == var4_4) break block7;
                                    v3 = var3_3;
                                    var4_4 = 4;
                                    if (v3 != null && v3 == var4_4) break block7;
                                    v4 = var3_3;
                                    var4_4 = 11;
                                    if (v4 != null && v4 == var4_4) break block7;
                                    v5 = var3_3;
                                    var4_4 = 7;
                                    if (v5 == null || v5 != var4_4) break block8;
                                }
                                v6 = NetworkType.NETWORK_2G;
                                break block9;
                            }
                            v7 = var3_3;
                            var4_4 = 5;
                            if (v7 != null && v7 == var4_4) break block10;
                            v8 = var3_3;
                            var4_4 = 6;
                            if (v8 != null && v8 == var4_4) break block10;
                            v9 = var3_3;
                            var4_4 = 12;
                            if (v9 != null && v9 == var4_4) break block10;
                            v10 = var3_3;
                            var4_4 = 8;
                            if (v10 != null && v10 == var4_4) break block10;
                            v11 = var3_3;
                            var4_4 = 9;
                            if (v11 != null && v11 == var4_4) break block10;
                            v12 = var3_3;
                            var4_4 = 10;
                            if (v12 != null && v12 == var4_4) break block10;
                            v13 = var3_3;
                            var4_4 = 15;
                            if (v13 != null && v13 == var4_4) break block10;
                            v14 = var3_3;
                            var4_4 = 14;
                            if (v14 == null || v14 != var4_4) break block11;
                        }
                        v6 = NetworkType.NETWORK_3G;
                        break block9;
                    }
                    v15 = var3_3;
                    var4_4 = 13;
                    if (v15 != null && v15 == var4_4) ** GOTO lbl-1000
                    v16 = var3_3;
                    var4_4 = 19;
                    if (v16 != null && v16 == var4_4) lbl-1000:
                    // 2 sources

                    {
                        v6 = NetworkType.NETWORK_4G;
                    } else {
                        v17 = var3_3;
                        var4_4 = 20;
                        if (v17 != null && v17 == var4_4) {
                            v6 = NetworkType.NETWORK_5G;
                        } else {
                            v18 = var3_3;
                            v6 = v18 != null && v18 == 0 ? NetworkType.NETWORK_UNKNOWN : NetworkType.NETWORK_UNKNOWN;
                        }
                    }
                }
                type = v6;
                break block5;
            }
            type = NetworkUtil.INSTANCE.getNetworkType();
        }
        return type;
    }

    private final void startTimer() {
        Log.i((String)TAG, (String)(this.getClassTag() + " --> startTimer() --> \u5f00\u542f\u5b9a\u65f6\u4efb\u52a1"));
        Companion.getMHandler().postDelayed(() -> NetWorkCallback.startTimer$lambda$12(this.timerRunnable), 120000L);
    }

    private final String logNetWorkType(NetworkCapabilities networkCapabilities) {
        String signalStrength;
        if (networkCapabilities == null) {
            return null;
        }
        String string = signalStrength = Build.VERSION.SDK_INT >= 29 ? " \u4fe1\u53f7\u5f3a\u5ea6 = " + networkCapabilities.getSignalStrength() : " \u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\u83b7\u53d6";
        if (networkCapabilities.hasTransport(0)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528\u8702\u7a9d\u4f20\u8f93\u3002 -- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(1)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 Wi-Fi \u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(2)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528\u84dd\u7259\u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(3)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528\u4ee5\u592a\u7f51\u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(4)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 VPN \u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(5)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 Wi-Fi \u611f\u77e5\u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(6)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 LoWPAN \u4f20\u8f93\u3002-- " + signalStrength;
        }
        if (networkCapabilities.hasTransport(8)) {
            return "\u8868\u793a\u6b64\u7f51\u7edc\u4f7f\u7528 USB \u4f20\u8f93\u3002-- " + signalStrength;
        }
        return null;
    }

    private static final Unit lostRunnable$lambda$6(NetWorkCallback this$0) {
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        boolean networkConnected = NetworkUtil.INSTANCE.isNetworkConnected((Context)application);
        Application application2 = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"getApp(...)");
        this$0.isValidated = NetworkUtil.INSTANCE.isNetworkCapability((Context)application2);
        int netState = this$0.getNetState();
        if (networkConnected) {
            this$0.isConnected = true;
            Log.i((String)TAG, (String)(this$0.getClassTag() + " --> onLost() --> disposeOnLost --> lostRunnable --> networkConnected = " + networkConnected + " netState = " + netState + " --  \u7f51\u7edc\u91cd\u65b0\u8fde\u63a5\u4e86"));
            Iterable $this$forEach$iv = this$0.mListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OnNetworkStatusChangedListener it = (OnNetworkStatusChangedListener)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this$0.isConnected, (Object)true)) continue;
                it.onConnected();
            }
        } else {
            this$0.reset();
            Log.i((String)TAG, (String)(this$0.getClassTag() + " --> onLost() --> disposeOnLost --> lostRunnable --> networkConnected = " + networkConnected + " netState = " + netState + " -- \u7f51\u7edc\u65ad\u5f00\u4e86"));
            Iterable $this$forEach$iv = this$0.mListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OnNetworkStatusChangedListener it = (OnNetworkStatusChangedListener)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this$0.isConnected, (Object)false)) continue;
                it.onDisconnected();
            }
        }
        return Unit.INSTANCE;
    }

    private static final void disposeOnLost$lambda$7(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void disposeOnLost$lambda$8(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void disposeConnect$lambda$10(NetWorkCallback this$0, Network $network, NetworkCapabilities $networkCapabilities) {
        Iterable $this$forEach$iv = this$0.mListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnNetworkStatusChangedListener it = (OnNetworkStatusChangedListener)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this$0.isConnected, (Object)true)) continue;
            it.onConnected($network, $networkCapabilities);
        }
    }

    private static final Unit timerRunnable$lambda$11(NetWorkCallback this$0) {
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        this$0.isValidated = NetworkUtil.INSTANCE.isNetworkCapability((Context)application);
        Log.i((String)TAG, (String)(this$0.getClassTag() + " --> timerRunnable --> isValidated = " + this$0.isValidated));
        this$0.startTimer();
        return Unit.INSTANCE;
    }

    private static final void startTimer$lambda$12(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Handler mHandler_delegate$lambda$13() {
        return new Handler(Looper.getMainLooper());
    }

    private static final NetWorkCallback INSTANCE_delegate$lambda$14() {
        return new NetWorkCallback();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/tn/lib/util/networkinfo/NetWorkCallback$Companion;", "", "<init>", "()V", "TAG", "", "mHandler", "Landroid/os/Handler;", "getMHandler", "()Landroid/os/Handler;", "mHandler$delegate", "Lkotlin/Lazy;", "INSTANCE", "Lcom/tn/lib/util/networkinfo/NetWorkCallback;", "getINSTANCE", "()Lcom/tn/lib/util/networkinfo/NetWorkCallback;", "INSTANCE$delegate", "utils_psRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Handler getMHandler() {
            Lazy lazy = mHandler$delegate;
            return (Handler)lazy.getValue();
        }

        @NotNull
        public final NetWorkCallback getINSTANCE() {
            Lazy lazy = INSTANCE$delegate;
            return (NetWorkCallback)((Object)lazy.getValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

