package com.transsion.baseui.utils

import android.net.Uri
import com.blankj.utilcode.util.SizeUtils
import java.net.URI

/**
 * Created by gaoxin.liu on 2024/7/3.
 * Description:一些扩展方法
 */
fun <T> List<T>.indexOfReference(element: T): Int {
    for ((index, value) in this.withIndex()) {
        if (value === element) return index
    }
    return -1
}

fun Uri.isHttp(): Boolean {
    return scheme == "https" || scheme == "http"
}

//移除url的参数
fun String.removeUrlParameters(): String {
    try {//url可能是本地带特殊字符的视频，解析会失败
        val uri = URI(this)
        return "${uri.scheme}://${uri.host}${uri.path}"
    } catch (e: Throwable) {
        return this
    }
}

fun Long.formatNumberKM(): String {
    return when {
        this in 1..999 -> this.toString()
        this in 1_000..999_999 -> "${this / 1_000}k"
        this >= 1_000_000 -> "${this / 1_000_000}m"
        else -> "0"
    }
}


fun Int.dp(): Int {
    return SizeUtils.dp2px(this.toFloat())
}

fun Float.dp(): Int {
    return SizeUtils.dp2px(this)
}
