package com.transsion.baseui.utils

const val DEFAULT_INTERVALS = 2000L
object FastClickUtils {

    private var lastClickTime: Long = 0
    private var lastClickViewId = 0

    fun isFastClick(id: Int, time: Long): Boolean {
        if (lastClickViewId != id) {
            lastClickViewId = id
            lastClickTime = System.currentTimeMillis()
            return false
        }
        val tmp: Long = System.currentTimeMillis() - lastClickTime
        if (tmp <= time) {
            return true
        }
        lastClickViewId = id
        lastClickTime = System.currentTimeMillis()
        return false
    }
}

private var preClickTime = 0L
// kotlin 全局防止快速点击
fun normalClick(time: Long = 600L, clickInvoke: () -> Unit) {
    if (System.currentTimeMillis() - preClickTime > time) {
        preClickTime = System.currentTimeMillis()
        clickInvoke.invoke()
    }
}