package com.transsion.baseui.utils

import android.content.Context
import android.content.pm.PackageInfo
import android.graphics.Color
import android.util.DisplayMetrics
import android.util.TypedValue
import com.blankj.utilcode.constant.MemoryConstants
import com.blankj.utilcode.util.ConvertUtils

/**
 *
 * @Description:    工具
 * @Version:        1.0
 */
object AppUtil {
    /**
     * dp转px
     * @return
     */
    fun dp2px(context: Context, dpVal: Float): Float {
        return TypedValue.applyDimension(
            TypedValue.COMPLEX_UNIT_DIP, dpVal, context.applicationContext.resources
                .displayMetrics
        )
    }

    var displayMetrics: DisplayMetrics? = null

    /**
     * 屏幕宽
     */
    fun getWidth(context: Context): Int {
        if (displayMetrics == null) {
            displayMetrics = context.resources.displayMetrics
        }
        return displayMetrics?.widthPixels ?: 0
    }


    /**
     * 屏幕高
     */
    fun getHeight(context: Context): Int {
        if (displayMetrics == null) {
            displayMetrics = context.resources.displayMetrics
        }
        return displayMetrics?.heightPixels ?: 0
    }

    /**
     * 根据fraction值来计算当前的颜色。 fraction值范围  0f-1f
     */
    fun getCurrentColor(fraction: Float, startColor: Int, endColor: Int): Int {
        val redCurrent: Int
        val blueCurrent: Int
        val greenCurrent: Int
        val alphaCurrent: Int
        val redStart: Int = Color.red(startColor)
        val blueStart: Int = Color.blue(startColor)
        val greenStart: Int = Color.green(startColor)
        val alphaStart: Int = Color.alpha(startColor)
        val redEnd: Int = Color.red(endColor)
        val blueEnd: Int = Color.blue(endColor)
        val greenEnd: Int = Color.green(endColor)
        val alphaEnd: Int = Color.alpha(endColor)
        val redDifference = redEnd - redStart
        val blueDifference = blueEnd - blueStart
        val greenDifference = greenEnd - greenStart
        val alphaDifference = alphaEnd - alphaStart
        redCurrent = (redStart + fraction * redDifference).toInt()
        blueCurrent = (blueStart + fraction * blueDifference).toInt()
        greenCurrent = (greenStart + fraction * greenDifference).toInt()
        alphaCurrent = (alphaStart + fraction * alphaDifference).toInt()
        return Color.argb(alphaCurrent, redCurrent, greenCurrent, blueCurrent)
    }


    fun memorySize2Byte(size: String): Long {
        //255.6MB
        val length = size.length
        var unit: String = ""
        var value: Long = 0
        if (length > 2) {
            unit = size.subSequence(length - 2, length).toString()
            value = size.subSequence(0, length - 2).trim().toString().toLong()
        }
        var res:Long = value
        when (unit) {
            "GB" ->
                res = ConvertUtils.memorySize2Byte(value, MemoryConstants.GB)

            "MB" ->
                res = ConvertUtils.memorySize2Byte(value, MemoryConstants.MB)

            "KB" ->
                res = ConvertUtils.memorySize2Byte(value, MemoryConstants.KB)
        }
        return res
    }

    fun isExists(context: Context?, packageName: String?): Boolean {
        if (context == null) {
            return false
        }
        val packageManager = context.packageManager
        val packageInfoN: PackageInfo?
        return try {
            packageInfoN = packageManager.getPackageInfo(packageName!!, 0)
            packageInfoN != null
        } catch (e: Exception) {
            false
        }
    }
}
