package com.transsion.baseui.utils;

/**
 * @author xiang.bai
 * @date 2020/8/5
 */
public class PhoneStateUtils {

    private final static String XOS = "xos";
    private final static String HIOS = "hios";
    private final static String TECNO = "tecno";
    private final static String INFINIX = "infinix";
    private final static String ITEL = "itel";
    private final static String UNDER_SCORE = "_";

    /**
     * 获取当前手机系统版本号
     *
     * @return 系统版本号
     */
    public static String getSystemVersion() {
        return android.os.Build.VERSION.RELEASE;
    }

    /**
     * 获取手机型号
     *
     * @return 手机型号
     */
    public static String getSystemModel() {
        return android.os.Build.MODEL;
    }

    /**
     * 获取手机厂商
     *
     * @return 手机厂商
     */
    public static String getDeviceBrand() {
        return android.os.Build.BRAND;
    }

    public static String getPhoneModel() {
        String brand = getDeviceBrand();
        String systemVersion = getSystemVersion();
        if (brand.toLowerCase().contains(TECNO)) {
            return systemVersion + UNDER_SCORE + HIOS;
        } else if (brand.toLowerCase().contains(INFINIX)) {
            return systemVersion + UNDER_SCORE + XOS;
        } else {
            return systemVersion + UNDER_SCORE + brand;
        }
    }

    /**
     * 判断是否是传音手机.
     *
     * @return
     */
    public static boolean isTranssionPhone() {
        String brand = getDeviceBrand();
        if (brand.toLowerCase().contains(TECNO) || brand.toLowerCase().contains(INFINIX) || brand.toLowerCase().contains(ITEL)) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isTranssionPhoneITEL() {
        String brand = getDeviceBrand();
        return brand.toLowerCase().contains(ITEL);
    }
}
