package com.transsion.baselib.exposure

import android.graphics.Rect
import android.util.Log
import android.util.SparseArray
import android.view.View
import androidx.core.util.forEach
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import java.util.*
import java.util.logging.Logger

class ListExposureHelper
/**
 * @param dimThreshold 0~1.0
 * @param callback     IExposureCallback
 */ @JvmOverloads constructor(
    private val showPercent: Float,
    private val callback: IExposureCallback, //    private static final String TAG = "ExposureHelper";
    private val needOnceCallback: Boolean = false
) : RecyclerView.OnScrollListener() {
    private var checkType = 0 // 0 检查宽和高; 1 只需要检查宽; 2 只需要检查高度

    companion object {
        var TAG = "ExposureHelper"
    }

    fun setCheckType(checkType: Int) {
        this.checkType = checkType
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
//        if (newState == RecyclerView.SCROLL_STATE_IDLE) {
//            getVisibleViews(recyclerView)
//        }
        Log.d(TAG, "newState $newState")

    }

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
//        Logger.d(TAG, "dy $dy")
//        isFirstVisible++
//        if (isFirstVisible == 2) {
//            getVisibleViews(recyclerView)
//        }
        val lp = recyclerView.layoutManager as LinearLayoutManager
        onVerticalExposure(lp, if (lp.orientation == LinearLayoutManager.VERTICAL) dy > 0 else dx > 0)

    }


    fun onAdapterChange(manager: LinearLayoutManager, position: Int, isAttach: Boolean, ignoreVisible: Boolean = false) {
        if (isAttach) {
            val firstView = manager.findViewByPosition(position)
            if (ignoreVisible) {
                offerVerticalVisibleQueue(manager.itemCount, position, position)
            } else {
                val export = checkExposureViewDimension(firstView)
                Log.d(TAG, "firstView $firstView export $export count ${manager.itemCount}")
                if (export) {
                    offerVerticalVisibleQueue(manager.itemCount, position, position)
                }
            }
        }
    }


    private fun checkExposureViewDimension(view: View?): Boolean {
        if (null == view) {
            return false
        }
        val width = view.width
        val height = view.height
        val globalVisibleRect = Rect()
        val isVisibleRect = view.getGlobalVisibleRect(globalVisibleRect)
        return if (isVisibleRect) {
            val visibleWidth = globalVisibleRect.width()
            val visibleHeight = globalVisibleRect.height()
            when (checkType) {
                1 -> visibleWidth * 1.00 / width >= showPercent
                2 -> visibleHeight * 1.00 / height >= showPercent
                else -> visibleWidth * 1.00 / width >= showPercent && visibleHeight * 1.00 / height >= showPercent
            }
        } else {
            false
        }
    }


    //队列顶部Card的position
    private var preFirstExposure = 0

    //队列底部Card的position
    private var preLastExposure = 0

    /**
     * 处理垂直方向卡片曝光
     *
     * @param manager
     * @param isAttach    是否为添加上来
     */
    fun onVerticalExposure(manager: LinearLayoutManager, isUp: Boolean) {
        var firstVisiblePosition = manager.findFirstVisibleItemPosition()
        var lastVisiblePosition = manager.findLastVisibleItemPosition()
        //根据曝光比例判断第一个可见卡片是否需要曝光
        val firstView = manager.findViewByPosition(firstVisiblePosition)
        firstVisiblePosition =
            if (checkExposureViewDimension(firstView)) firstVisiblePosition else firstVisiblePosition + 1
        //根据曝光比例判断最后一个可见卡片是否需要曝光
        val lastView = manager.findViewByPosition(lastVisiblePosition)
        lastVisiblePosition =
            if (checkExposureViewDimension(lastView)) lastVisiblePosition else lastVisiblePosition - 1
        if (preFirstExposure == 0 && preLastExposure == 0) {
            offerVerticalVisibleQueue(
                manager.itemCount,
                firstVisiblePosition,
                lastVisiblePosition
            )
            //更新队列的顶部position和底部position
            preFirstExposure = firstVisiblePosition
            preLastExposure = lastVisiblePosition
            return
        }
        if (isUp) {
            //向上滑动，把顶部不可见Card从顶部出队，底部进入可曝光的卡片入队
            popVerticalVisibleQueue(manager.itemCount, preFirstExposure, firstVisiblePosition - 1)
            offerVerticalVisibleQueue(manager.itemCount, preLastExposure + 1, lastVisiblePosition)
        } else {
            //对应向下滑动的策略
            popVerticalVisibleQueue(manager.itemCount, lastVisiblePosition + 1, preLastExposure)
            offerVerticalVisibleQueue(manager.itemCount, firstVisiblePosition, preFirstExposure - 1)
        }
        //更新队列的顶部position和底部position
        preFirstExposure = firstVisiblePosition
        preLastExposure = lastVisiblePosition
    }


    /**
     * 入队操作
     *
     * @param start
     * @param end
     * @param isFirst 是否从顶部入队
     */
    private fun offerVerticalVisibleQueue(itemCount: Int, start: Int, end: Int) {
        if (start >= 0 && end < itemCount && start <= end) {
            for (position in start..end) {
                if (sparseArray[position] != null) {
                    return
                }
                Log.d(TAG, "offer position  $position")
                sparseArray.put(position, System.currentTimeMillis())
            }
        }
    }


    /**
     * 出队操作
     *
     * @param start
     * @param end
     * @param isFirst 是否从顶部出队
     */
    private fun popVerticalVisibleQueue(itemCount: Int, start: Int, end: Int) {
        if (start >= 0 && end < itemCount && start <= end) {
            for (i in end downTo start) {
                onVerticalItemSlideOut(i)
            }
        }
    }

    fun clearCache() {
        val currentTime = System.currentTimeMillis()
        sparseArray.forEach { position, startTime ->
            val duration = currentTime - (startTime ?: currentTime)
            Log.d(TAG, "clearCache out position $position duration $duration")
            callback.exposure(position, duration, null)
        }
        sparseArray.clear()
    }


    private val sparseArray = SparseArray<Long?>()


    /**
     * 处理滑出（出队）停止曝光的卡片
     *
     * @param position
     * @param isFirst  是否从顶部滑出（出队）
     */
    private fun onVerticalItemSlideOut(position: Int) {
        if (sparseArray[position] == null) {
            return
        }
        val currentTime = System.currentTimeMillis()
        val intoTime = sparseArray[position] ?: currentTime
        sparseArray.remove(position)
        val duration = currentTime - intoTime
        Log.d(TAG, "out position $position duration $duration")
        if (duration <= 1000) {
            return
        }
        //回调卡片结束曝光事件
//        callItemEndExposure(position, isFirst)
        callback.exposure(position, duration, null)
    }


}