/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.util.expose;

import android.graphics.Rect;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 22\u00020\u0001:\u000212B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0012J\u001a\u0010\u001f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\u0005J\b\u0010!\u001a\u00020\u0012H\u0002J\u001a\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020'H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tn/lib/util/expose/RecyclerViewExposeUtil;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "<init>", "()V", "mItemOnExposeListener", "Lcom/tn/lib/util/expose/RecyclerViewExposeUtil$OnItemExposeListener;", "mVisiblePercentage", "", "mExposureType", "mRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "sparseArray", "Landroid/util/SparseArray;", "", "getClassTag", "", "kotlin.jvm.PlatformType", "onScrollStateChanged", "", "recyclerView", "newState", "onScrolled", "dx", "dy", "setVisiblePercentage", "visiblePercentage", "setExposureType", "exposureType", "reset", "destroy", "manualCallReporting", "setRecyclerItemExposeListener", "onExposeListener", "handleCurrentVisibleItems", "setCallbackForLogicVisibleView", "view", "Landroid/view/View;", "position", "findRangeLinear", "", "manager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "findRangeGrid", "Landroidx/recyclerview/widget/GridLayoutManager;", "findRangeStaggeredGrid", "Landroidx/recyclerview/widget/StaggeredGridLayoutManager;", "findRange", "startPos", "endPos", "OnItemExposeListener", "Companion", "utils_psRelease"})
public final class RecyclerViewExposeUtil
extends RecyclerView.OnScrollListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private OnItemExposeListener mItemOnExposeListener;
    private int mVisiblePercentage = 10;
    private int mExposureType = 2;
    @Nullable
    private RecyclerView mRecyclerView;
    @NotNull
    private final SparseArray<Long> sparseArray = new SparseArray();
    public static final int EXPOSURE_TYPE_ONE_TIME_ONLY = 1;
    public static final int EXPOSURE_TYPE_INVISIBLE_TO_VISIBLE = 2;

    private final String getClassTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super.onScrolled(recyclerView, dx, dy);
        this.handleCurrentVisibleItems();
    }

    public final void setVisiblePercentage(int visiblePercentage) {
        this.mVisiblePercentage = visiblePercentage < 5 ? 5 : visiblePercentage;
    }

    public final void setExposureType(int exposureType) {
        this.mExposureType = exposureType;
    }

    public final void reset() {
        this.sparseArray.clear();
    }

    public final void destroy() {
        this.reset();
        RecyclerView recyclerView = this.mRecyclerView;
        if (recyclerView != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
        }
        this.mItemOnExposeListener = null;
        this.mRecyclerView = null;
    }

    public final void manualCallReporting() {
        this.handleCurrentVisibleItems();
    }

    public final void setRecyclerItemExposeListener(@Nullable RecyclerView recyclerView, @Nullable OnItemExposeListener onExposeListener) {
        block5: {
            block4: {
                block3: {
                    this.mItemOnExposeListener = onExposeListener;
                    this.mRecyclerView = recyclerView;
                    if (this.mRecyclerView == null) break block3;
                    RecyclerView recyclerView2 = this.mRecyclerView;
                    if (recyclerView2 != null ? recyclerView2.getVisibility() == 0 : false) break block4;
                }
                return;
            }
            RecyclerView recyclerView3 = this.mRecyclerView;
            if (recyclerView3 == null) break block5;
            recyclerView3.addOnScrollListener((RecyclerView.OnScrollListener)this);
        }
    }

    private final void handleCurrentVisibleItems() {
        Object object;
        block15: {
            block14: {
                if (this.mRecyclerView == null) break block14;
                RecyclerView recyclerView = this.mRecyclerView;
                boolean bl = recyclerView != null ? recyclerView.getVisibility() == 0 : false;
                if (!bl) break block14;
                RecyclerView recyclerView2 = this.mRecyclerView;
                if (recyclerView2 != null ? !recyclerView2.isShown() : false) break block14;
                RecyclerView recyclerView3 = this.mRecyclerView;
                boolean bl2 = recyclerView3 != null ? !recyclerView3.getGlobalVisibleRect(new Rect()) : false;
                if (!bl2) break block15;
            }
            return;
        }
        try {
            RecyclerView.LayoutManager manager;
            boolean bl = false;
            int[] range = new int[2];
            RecyclerView recyclerView = this.mRecyclerView;
            RecyclerView.LayoutManager layoutManager = manager = recyclerView != null ? recyclerView.getLayoutManager() : null;
            if (layoutManager instanceof GridLayoutManager) {
                range = this.findRangeGrid((GridLayoutManager)manager);
            } else if (layoutManager instanceof LinearLayoutManager) {
                range = this.findRangeLinear((LinearLayoutManager)manager);
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                range = this.findRangeStaggeredGrid((StaggeredGridLayoutManager)manager);
            }
            int i = range[0];
            int n = range[1];
            if (i <= n) {
                while (true) {
                    OnItemExposeListener onItemExposeListener;
                    if (!((onItemExposeListener = this.mItemOnExposeListener) != null ? i == onItemExposeListener.getTotalSize() : false)) {
                        RecyclerView.LayoutManager layoutManager2 = manager;
                        this.setCallbackForLogicVisibleView((View)(layoutManager2 != null ? layoutManager2.findViewByPosition(i) : null), i);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable range) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)range));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Log.e((String)this.getClassTag(), (String)("RecyclerViewExposeUtil --> handleCurrentVisibleItems() --> " + Log.getStackTraceString((Throwable)it)));
        }
    }

    private final void setCallbackForLogicVisibleView(View view, int position) {
        double total;
        if (view == null || view.getVisibility() != 0 || !view.isShown() || !view.getGlobalVisibleRect(new Rect())) {
            return;
        }
        Rect rect = new Rect();
        boolean cover = view.getGlobalVisibleRect(rect);
        double exposure = (double)rect.height() * (double)rect.width();
        boolean isItemViewVisibleInLogic = exposure > (total = (double)view.getMeasuredHeight() * (double)view.getMeasuredWidth()) * (double)this.mVisiblePercentage / (double)100;
        Log.i((String)"exposure_log", (String)("isItemViewVisibleInLogic = " + isItemViewVisibleInLogic));
        if (cover && isItemViewVisibleInLogic) {
            if (this.sparseArray.get(position) != null) {
                return;
            }
            this.sparseArray.put(position, (Object)System.currentTimeMillis());
            OnItemExposeListener onItemExposeListener = this.mItemOnExposeListener;
            if (onItemExposeListener != null) {
                onItemExposeListener.onItemViewVisible(true, position);
            }
        } else {
            OnItemExposeListener onItemExposeListener = this.mItemOnExposeListener;
            if (onItemExposeListener != null) {
                onItemExposeListener.onItemViewVisible(false, position);
            }
            if (this.mExposureType == 2) {
                this.sparseArray.remove(position);
            }
        }
    }

    private final int[] findRangeLinear(LinearLayoutManager manager) {
        int[] range = new int[]{manager.findFirstVisibleItemPosition(), manager.findLastVisibleItemPosition()};
        return range;
    }

    private final int[] findRangeGrid(GridLayoutManager manager) {
        int[] range = new int[]{manager.findFirstVisibleItemPosition(), manager.findLastVisibleItemPosition()};
        return range;
    }

    private final int[] findRangeStaggeredGrid(StaggeredGridLayoutManager manager) {
        int[] startPos = new int[manager.getSpanCount()];
        int[] endPos = new int[manager.getSpanCount()];
        manager.findFirstVisibleItemPositions(startPos);
        manager.findLastVisibleItemPositions(endPos);
        return this.findRange(startPos, endPos);
    }

    private final int[] findRange(int[] startPos, int[] endPos) {
        int i;
        int start = startPos[0];
        int end = endPos[0];
        int n = startPos.length;
        for (i = 1; i < n; ++i) {
            if (start <= startPos[i]) continue;
            start = startPos[i];
        }
        n = endPos.length;
        for (i = 1; i < n; ++i) {
            if (end >= endPos[i]) continue;
            end = endPos[i];
        }
        int[] nArray = new int[]{start, end};
        return nArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/tn/lib/util/expose/RecyclerViewExposeUtil$Companion;", "", "<init>", "()V", "EXPOSURE_TYPE_ONE_TIME_ONLY", "", "EXPOSURE_TYPE_INVISIBLE_TO_VISIBLE", "utils_psRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lcom/tn/lib/util/expose/RecyclerViewExposeUtil$OnItemExposeListener;", "", "onItemViewVisible", "", "visible", "", "position", "", "getTotalSize", "utils_psRelease"})
    public static interface OnItemExposeListener {
        public void onItemViewVisible(boolean var1, int var2);

        public int getTotalSize();
    }
}

