/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.baseui.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.blankj.utilcode.util.ConvertUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/transsion/baseui/utils/AppUtil;", "", "<init>", "()V", "dp2px", "", "context", "Landroid/content/Context;", "dpVal", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "setDisplayMetrics", "(Landroid/util/DisplayMetrics;)V", "getWidth", "", "getHeight", "getCurrentColor", "fraction", "startColor", "endColor", "memorySize2Byte", "", "size", "", "isExists", "", "packageName", "utils_psRelease"})
public final class AppUtil {
    @NotNull
    public static final AppUtil INSTANCE = new AppUtil();
    @Nullable
    private static DisplayMetrics displayMetrics;

    private AppUtil() {
    }

    public final float dp2px(@NotNull Context context, float dpVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getApplicationContext().getResources().getDisplayMetrics());
    }

    @Nullable
    public final DisplayMetrics getDisplayMetrics() {
        return displayMetrics;
    }

    public final void setDisplayMetrics(@Nullable DisplayMetrics displayMetrics) {
        AppUtil.displayMetrics = displayMetrics;
    }

    public final int getWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (displayMetrics == null) {
            displayMetrics = context.getResources().getDisplayMetrics();
        }
        DisplayMetrics displayMetrics = AppUtil.displayMetrics;
        return displayMetrics != null ? displayMetrics.widthPixels : 0;
    }

    public final int getHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (displayMetrics == null) {
            displayMetrics = context.getResources().getDisplayMetrics();
        }
        DisplayMetrics displayMetrics = AppUtil.displayMetrics;
        return displayMetrics != null ? displayMetrics.heightPixels : 0;
    }

    public final int getCurrentColor(float fraction, int startColor, int endColor) {
        int redCurrent = 0;
        int blueCurrent = 0;
        int greenCurrent = 0;
        int alphaCurrent = 0;
        int redStart = Color.red((int)startColor);
        int blueStart = Color.blue((int)startColor);
        int greenStart = Color.green((int)startColor);
        int alphaStart = Color.alpha((int)startColor);
        int redEnd = Color.red((int)endColor);
        int blueEnd = Color.blue((int)endColor);
        int greenEnd = Color.green((int)endColor);
        int alphaEnd = Color.alpha((int)endColor);
        int redDifference = redEnd - redStart;
        int blueDifference = blueEnd - blueStart;
        int greenDifference = greenEnd - greenStart;
        int alphaDifference = alphaEnd - alphaStart;
        redCurrent = (int)((float)redStart + fraction * (float)redDifference);
        blueCurrent = (int)((float)blueStart + fraction * (float)blueDifference);
        greenCurrent = (int)((float)greenStart + fraction * (float)greenDifference);
        alphaCurrent = (int)((float)alphaStart + fraction * (float)alphaDifference);
        return Color.argb((int)alphaCurrent, (int)redCurrent, (int)greenCurrent, (int)blueCurrent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long memorySize2Byte(@NotNull String size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        int length = size.length();
        String unit = "";
        long value = 0L;
        if (length > 2) {
            unit = ((Object)size.subSequence(length - 2, length)).toString();
            value = Long.parseLong(((Object)StringsKt.trim((CharSequence)size.subSequence(0, length - 2))).toString());
        }
        long res = value;
        String string = unit;
        switch (string.hashCode()) {
            case 2453: {
                if (string.equals("MB")) return ConvertUtils.memorySize2Byte((long)value, (int)0x100000);
                return res;
            }
            case 2391: {
                if (string.equals("KB")) return ConvertUtils.memorySize2Byte((long)value, (int)1024);
                return res;
            }
            case 2267: {
                if (!string.equals("GB")) return res;
                return ConvertUtils.memorySize2Byte((long)value, (int)0x40000000);
            }
        }
        return res;
    }

    public final boolean isExists(@Nullable Context context, @Nullable String packageName) {
        boolean bl;
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfoN = null;
        try {
            String string = packageName;
            Intrinsics.checkNotNull((Object)string);
            packageInfoN = packageManager.getPackageInfo(string, 0);
            bl = packageInfoN != null;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }
}

