package com.tn.lib.util.networkinfo

import android.net.Network
import android.net.NetworkCapabilities

/**
 * @author xinbing.zhang
 * @date :2023/1/30 16:50
 * @description: 网络状态监听
 */
interface OnNetworkStatusChangedListener {

    /**
     * 网络断开
     */
    fun onDisconnected()

    /**
     * 网络连接并且可用
     */
    fun onConnected(network: Network, networkCapabilities: NetworkCapabilities)

    /**
     * 断网重新Check之后如果有网络的回调
     */
    fun onConnected(){
        //
    }
}