package com.transsion.baseui.utils

import android.os.Build
import com.blankj.utilcode.constant.MemoryConstants
import com.blankj.utilcode.util.Utils
import com.tn.lib.util.device.TNDeviceHelper

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2023/12/19 16:36
 *
 *   Desc
 */
object DeviceInfo {
    private var less4gMemoryDevice:Boolean? = null

    /**
     * 8.0及以下  内存4g以下 均为低内存设备
     * @return Boolean
     */
    fun less4gMemoryDevice(): Boolean {
        if (less4gMemoryDevice != null) {
            return less4gMemoryDevice ?: false
        }
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.O) {
            less4gMemoryDevice = true
        }
        val totalMem = TNDeviceHelper.getMemoryInfo(Utils.getApp()).totalMem
        if (totalMem <= MemoryConstants.GB.times(4L)) {
            less4gMemoryDevice = true
        }
        return less4gMemoryDevice ?: false
    }

    private var lowMemoryDevice: Boolean? = null
    /**
     * 是否为低于某个内存
     * @param memorySize Int
     * @return Boolean
     */
    fun lowMemoryDevice(): Boolean {
        if (lowMemoryDevice != null) {
            return lowMemoryDevice ?: false
        }

        try {
            val totalMem = TNDeviceHelper.getMemoryInfo(Utils.getApp()).totalMem
            val lowMemoryValue = "1.0".toDouble()
            if (totalMem <= MemoryConstants.GB.times(lowMemoryValue)) {
                lowMemoryDevice = true
            }
            return lowMemoryDevice ?: false
        } catch (e: Exception) {
            return false
        }
    }

}