package com.transsion.baseui.utils

import androidx.annotation.ColorRes
import androidx.annotation.DimenRes
import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import androidx.core.content.ContextCompat
import com.blankj.utilcode.util.Utils

inline val @receiver:StringRes Int.str get() = Utils.getApp().getString(this)
fun @receiver:StringRes Int.str(vararg formatArgs: String) = Utils.getApp().getString(this, formatArgs)

inline val @receiver:ColorRes Int.color get() = ContextCompat.getColor(Utils.getApp(), this)
inline val @receiver:ColorRes Int.colorStateList get() = ContextCompat.getColorStateList(
    Utils.getApp(), this)

inline val @receiver:DrawableRes Int.drawable get() = ContextCompat.getDrawable(Utils.getApp(), this)

inline val @receiver:DimenRes Int.dimen get() = Utils.getApp().resources.getDimensionPixelSize(this)