package com.tn.lib.util.device.oaid

import android.app.Application
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.content.ServiceConnection
import android.os.IBinder
import android.util.Log
import com.tn.lib.util.device.TNDeviceHelper

/**
 * 绑定远程的 OAID 服务
 */
class OAIDService private constructor(context: Context, intent: Intent) : ServiceConnection {
    private val TAG=this.javaClass.simpleName
    private var context: Context? = null

    override fun onServiceConnected(name: ComponentName, service: IBinder) {
        try {
            val anInterface = IAdvertisingIdService.Stub.asInterface(service)
            val oaid = anInterface.id
            TNDeviceHelper.saveGaid(oaid)

            Log.d(TAG, "onServiceConnected oaid=$oaid")
        } catch (e: Exception) {
            e.printStackTrace()
        } finally {
            try {
                context?.unbindService(this)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    override fun onServiceDisconnected(name: ComponentName) {}

    companion object {
        fun bind(context: Context, intent: Intent) {
            OAIDService(context, intent)
        }
    }

    init {
        if (context is Application) {
            this.context = context
        } else {
            this.context = context.applicationContext
        }
        try {
            val ret = context.bindService(intent, this, Context.BIND_AUTO_CREATE)
            if (!ret) {
                Log.d(TAG, "Service binding failed")
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}