/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.baselib.exposure;

import android.graphics.Rect;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.baselib.exposure.IExposureCallback;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u0007J\u0012\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0007J \u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002J \u0010&\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0006\u0010'\u001a\u00020\rJ\u0010\u0010+\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/transsion/baselib/exposure/ListExposureHelper;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "showPercent", "", "callback", "Lcom/transsion/baselib/exposure/IExposureCallback;", "needOnceCallback", "", "<init>", "(FLcom/transsion/baselib/exposure/IExposureCallback;Z)V", "checkType", "", "setCheckType", "", "onScrollStateChanged", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "newState", "onScrolled", "dx", "dy", "onAdapterChange", "manager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "position", "isAttach", "ignoreVisible", "checkExposureViewDimension", "view", "Landroid/view/View;", "preFirstExposure", "preLastExposure", "onVerticalExposure", "isUp", "offerVerticalVisibleQueue", "itemCount", "start", "end", "popVerticalVisibleQueue", "clearCache", "sparseArray", "Landroid/util/SparseArray;", "", "onVerticalItemSlideOut", "Companion", "utils_psRelease"})
@SourceDebugExtension(value={"SMAP\nListExposureHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListExposureHelper.kt\ncom/transsion/baselib/exposure/ListExposureHelper\n+ 2 SparseArray.kt\nandroidx/core/util/SparseArrayKt\n*L\n1#1,213:1\n77#2,4:214\n*S KotlinDebug\n*F\n+ 1 ListExposureHelper.kt\ncom/transsion/baselib/exposure/ListExposureHelper\n*L\n177#1:214,4\n*E\n"})
public final class ListExposureHelper
extends RecyclerView.OnScrollListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float showPercent;
    @NotNull
    private final IExposureCallback callback;
    private final boolean needOnceCallback;
    private int checkType;
    private int preFirstExposure;
    private int preLastExposure;
    @NotNull
    private final SparseArray<Long> sparseArray;
    @NotNull
    private static String TAG = "ExposureHelper";

    @JvmOverloads
    public ListExposureHelper(float showPercent, @NotNull IExposureCallback callback, boolean needOnceCallback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.showPercent = showPercent;
        this.callback = callback;
        this.needOnceCallback = needOnceCallback;
        this.sparseArray = new SparseArray();
    }

    public /* synthetic */ ListExposureHelper(float f, IExposureCallback iExposureCallback, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(f, iExposureCallback, bl);
    }

    public final void setCheckType(int checkType) {
        this.checkType = checkType;
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Log.d((String)TAG, (String)("newState " + newState));
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super.onScrolled(recyclerView, dx, dy);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
        LinearLayoutManager lp = (LinearLayoutManager)layoutManager;
        this.onVerticalExposure(lp, lp.getOrientation() == 1 ? dy > 0 : dx > 0);
    }

    public final void onAdapterChange(@NotNull LinearLayoutManager manager, int position, boolean isAttach, boolean ignoreVisible) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (isAttach) {
            View firstView = manager.findViewByPosition(position);
            if (ignoreVisible) {
                this.offerVerticalVisibleQueue(manager.getItemCount(), position, position);
            } else {
                boolean export = this.checkExposureViewDimension(firstView);
                Log.d((String)TAG, (String)("firstView " + firstView + " export " + export + " count " + manager.getItemCount()));
                if (export) {
                    this.offerVerticalVisibleQueue(manager.getItemCount(), position, position);
                }
            }
        }
    }

    public static /* synthetic */ void onAdapterChange$default(ListExposureHelper listExposureHelper, LinearLayoutManager linearLayoutManager, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        listExposureHelper.onAdapterChange(linearLayoutManager, n, bl, bl2);
    }

    private final boolean checkExposureViewDimension(View view) {
        boolean bl;
        if (view == null) {
            return false;
        }
        int width = view.getWidth();
        int height = view.getHeight();
        Rect globalVisibleRect = new Rect();
        boolean isVisibleRect = view.getGlobalVisibleRect(globalVisibleRect);
        if (isVisibleRect) {
            int visibleWidth = globalVisibleRect.width();
            int visibleHeight = globalVisibleRect.height();
            switch (this.checkType) {
                case 1: {
                    if ((double)visibleWidth * 1.0 / (double)width >= (double)this.showPercent) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if ((double)visibleHeight * 1.0 / (double)height >= (double)this.showPercent) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    if ((double)visibleWidth * 1.0 / (double)width >= (double)this.showPercent && (double)visibleHeight * 1.0 / (double)height >= (double)this.showPercent) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final void onVerticalExposure(@NotNull LinearLayoutManager manager, boolean isUp) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        int firstVisiblePosition = manager.findFirstVisibleItemPosition();
        int lastVisiblePosition = manager.findLastVisibleItemPosition();
        View firstView = manager.findViewByPosition(firstVisiblePosition);
        firstVisiblePosition = this.checkExposureViewDimension(firstView) ? firstVisiblePosition : firstVisiblePosition + 1;
        View lastView = manager.findViewByPosition(lastVisiblePosition);
        int n = lastVisiblePosition = this.checkExposureViewDimension(lastView) ? lastVisiblePosition : lastVisiblePosition - 1;
        if (this.preFirstExposure == 0 && this.preLastExposure == 0) {
            this.offerVerticalVisibleQueue(manager.getItemCount(), firstVisiblePosition, lastVisiblePosition);
            this.preFirstExposure = firstVisiblePosition;
            this.preLastExposure = lastVisiblePosition;
            return;
        }
        if (isUp) {
            this.popVerticalVisibleQueue(manager.getItemCount(), this.preFirstExposure, firstVisiblePosition - 1);
            this.offerVerticalVisibleQueue(manager.getItemCount(), this.preLastExposure + 1, lastVisiblePosition);
        } else {
            this.popVerticalVisibleQueue(manager.getItemCount(), lastVisiblePosition + 1, this.preLastExposure);
            this.offerVerticalVisibleQueue(manager.getItemCount(), firstVisiblePosition, this.preFirstExposure - 1);
        }
        this.preFirstExposure = firstVisiblePosition;
        this.preLastExposure = lastVisiblePosition;
    }

    private final void offerVerticalVisibleQueue(int itemCount, int start, int end) {
        int position;
        if (start >= 0 && end < itemCount && start <= end && (position = start) <= end) {
            while (true) {
                if (this.sparseArray.get(position) != null) {
                    return;
                }
                Log.d((String)TAG, (String)("offer position  " + position));
                this.sparseArray.put(position, (Object)System.currentTimeMillis());
                if (position == end) break;
                ++position;
            }
        }
    }

    private final void popVerticalVisibleQueue(int itemCount, int start, int end) {
        int i;
        if (start >= 0 && end < itemCount && start <= end && start <= (i = end)) {
            while (true) {
                this.onVerticalItemSlideOut(i);
                if (i == start) break;
                --i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearCache() {
        long currentTime = System.currentTimeMillis();
        SparseArray<Long> $this$forEach$iv = this.sparseArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void startTime;
            Long l = (Long)$this$forEach$iv.valueAt(index$iv);
            int position = $this$forEach$iv.keyAt(index$iv);
            boolean bl = false;
            void v0 = startTime;
            long duration = currentTime - (v0 != null ? v0.longValue() : currentTime);
            Log.d((String)TAG, (String)("clearCache out position " + position + " duration " + duration));
            this.callback.exposure(position, duration, null);
        }
        this.sparseArray.clear();
    }

    private final void onVerticalItemSlideOut(int position) {
        if (this.sparseArray.get(position) == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Long l = (Long)this.sparseArray.get(position);
        long intoTime = l != null ? l : currentTime;
        this.sparseArray.remove(position);
        long duration = currentTime - intoTime;
        Log.d((String)TAG, (String)("out position " + position + " duration " + duration));
        if (duration <= 1000L) {
            return;
        }
        this.callback.exposure(position, duration, null);
    }

    @JvmOverloads
    public ListExposureHelper(float showPercent, @NotNull IExposureCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this(showPercent, callback, false, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/transsion/baselib/exposure/ListExposureHelper$Companion;", "", "<init>", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "utils_psRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            TAG = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

