/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.baseui.utils;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"byte2FitMemorySize", "", "byteSize", "", "mbPrecision", "", "kbPrecision", "formatDownloadMinAndSec", "seconds", "utils_psRelease"})
public final class ConvertUtilKt {
    @NotNull
    public static final String byte2FitMemorySize(long byteSize, int mbPrecision, int kbPrecision) {
        String string;
        if (byteSize < 0L) {
            throw new IllegalArgumentException("byteSize shouldn't be less than zero!");
        }
        if (byteSize < 1024L) {
            Locale locale = Locale.ENGLISH;
            String string2 = "%." + kbPrecision + "fB";
            Object[] objectArray = new Object[]{(double)byteSize};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else if (byteSize < 0x100000L) {
            Locale locale = Locale.ENGLISH;
            String string4 = "%." + kbPrecision + "fKB";
            Object[] objectArray = new Object[]{(double)byteSize / (double)1024};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else if (byteSize < 0x40000000L) {
            Locale locale = Locale.ENGLISH;
            String string6 = "%." + mbPrecision + "fMB";
            Object[] objectArray = new Object[]{(double)byteSize / (double)0x100000};
            String string7 = String.format(locale, string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        } else {
            Locale locale = Locale.ENGLISH;
            String string8 = "%." + mbPrecision + "fGB";
            Object[] objectArray = new Object[]{(double)byteSize / (double)0x40000000};
            String string9 = String.format(locale, string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        }
        return string;
    }

    @NotNull
    public static final String formatDownloadMinAndSec(int seconds) {
        int h = seconds / 3600;
        int space = seconds % 3600;
        int min = space / 60;
        int sec = seconds % 60;
        StringBuilder sb = new StringBuilder();
        if (h > 0) {
            sb.append(h).append(" h ");
        }
        if (min > 0) {
            sb.append(min).append(" min ");
        }
        if (sec > 0) {
            sb.append(sec).append(" sec");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

