/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.paysdk.manager.entity;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.transsion.pay.paysdk.manager.pay.PayUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;

public class PaynicornSpInfo
implements Parcelable {
    public static final Parcelable.Creator<PaynicornSpInfo> CREATOR = new Parcelable.Creator<PaynicornSpInfo>(){

        public PaynicornSpInfo createFromParcel(Parcel parcel) {
            return new PaynicornSpInfo(parcel);
        }

        public PaynicornSpInfo[] newArray(int n) {
            return new PaynicornSpInfo[n];
        }
    };
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="icon")
    public String icon;
    @SerializedName(value="code")
    public String spCode;
    @SerializedName(value="maxAmount")
    public double maxAmount;
    @SerializedName(value="minAmount")
    public double minAmount;
    @SerializedName(value="methodType")
    public String type;
    @SerializedName(value="discreteAmount")
    public double[] supportAmounts;
    @SerializedName(value="discountRatio")
    public float discountRatio;
    @Expose(serialize=false, deserialize=false)
    public transient boolean isSMS;
    @Expose(serialize=false, deserialize=false)
    public transient double actualAmount;
    @Expose(serialize=false, deserialize=false)
    public transient double discount;
    @Expose(serialize=false, deserialize=false)
    public transient boolean smsAmountUp = false;
    @SerializedName(value="mccmncSubscribeAmount")
    public MCCMNCSubscribeAmount mccmncSubscribeAmount;
    @SerializedName(value="supportBizType")
    public int supportBizType;

    public PaynicornSpInfo() {
    }

    public PaynicornSpInfo(Parcel parcel) {
        this.name = parcel.readString();
        this.icon = parcel.readString();
        this.spCode = parcel.readString();
        this.maxAmount = parcel.readDouble();
        this.minAmount = parcel.readDouble();
        this.type = parcel.readString();
        this.supportAmounts = parcel.createDoubleArray();
        this.discountRatio = parcel.readFloat();
        this.supportBizType = parcel.readInt();
    }

    public static JSONObject entityToJson(PaynicornSpInfo object) {
        try {
            object = PayUtil.toJson(object);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new JSONObject((String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PaynicornSpInfo jsonToEntity(JSONObject object) {
        double d;
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        try {
            BigDecimal bigDecimal4;
            object = PayUtil.fromJson(object.toString(), PaynicornSpInfo.class);
            if (((PaynicornSpInfo)object).supportAmounts != null && ((PaynicornSpInfo)object).maxAmount == 0.0) {
                ((PaynicornSpInfo)object).maxAmount = Double.MAX_VALUE;
                return object;
            }
            if (!((PaynicornSpInfo)object).isDiscountRatioValid()) return object;
            Object object2 = object;
            bigDecimal3 = new BigDecimal(((PaynicornSpInfo)object).maxAmount);
            bigDecimal2 = bigDecimal4;
            bigDecimal = bigDecimal4;
            d = ((PaynicornSpInfo)object).discountRatio;
        }
        catch (Throwable throwable) {
            return null;
        }
        bigDecimal2(d);
        ((PaynicornSpInfo)object2).maxAmount = bigDecimal3.divide(bigDecimal, 0, 1).doubleValue();
        return object;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.name);
        parcel.writeString(this.icon);
        parcel.writeString(this.spCode);
        parcel.writeDouble(this.maxAmount);
        parcel.writeDouble(this.minAmount);
        parcel.writeString(this.type);
        parcel.writeDoubleArray(this.supportAmounts);
        parcel.writeFloat(this.discountRatio);
        parcel.writeInt(this.supportBizType);
    }

    public int describeContents() {
        return 0;
    }

    public boolean isVas() {
        return this.isSMS || TextUtils.equals((CharSequence)this.type, (CharSequence)"VAS");
    }

    public boolean isNoDcpVas() {
        return this.isSMS;
    }

    public boolean isDiscountRatioValid() {
        float f;
        float f2 = this.discountRatio;
        return f > 0.0f && f2 < 1.0f;
    }

    public static class SubscribeAmountDTO
    implements Parcelable {
        public static final Parcelable.Creator<SubscribeAmountDTO> CREATOR = new Parcelable.Creator<SubscribeAmountDTO>(){

            public SubscribeAmountDTO createFromParcel(Parcel parcel) {
                return new SubscribeAmountDTO(parcel);
            }

            public SubscribeAmountDTO[] newArray(int n) {
                return new SubscribeAmountDTO[n];
            }
        };
        @SerializedName(value="cycle")
        public String cycle;
        @SerializedName(value="amount")
        public double amount;

        public SubscribeAmountDTO() {
        }

        public SubscribeAmountDTO(Parcel parcel) {
            this.cycle = parcel.readString();
            this.amount = parcel.readDouble();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.cycle);
            parcel.writeDouble(this.amount);
        }

        public void readFromParcel(Parcel parcel) {
            this.cycle = parcel.readString();
            this.amount = parcel.readDouble();
        }
    }

    public static class MCCMNCSubscribeAmount
    extends HashMap<String, List<SubscribeAmountDTO>> {
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && MCCMNCSubscribeAmount.class == object.getClass()) {
                return super.equals(object);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder;
            MCCMNCSubscribeAmount mCCMNCSubscribeAmount = serializable;
            Serializable serializable = stringBuilder;
            new StringBuilder().append("class MCCMNCSubscribeAmount {\n");
            StringBuilder stringBuilder2 = ((StringBuilder)serializable).append("    ");
            String string2 = super.toString();
            string2 = string2 == null ? "null" : string2.toString().replace("\n", "\n    ");
            Serializable serializable2 = serializable;
            stringBuilder2.append(string2).append("\n");
            ((StringBuilder)serializable2).append("}");
            return ((StringBuilder)serializable2).toString();
        }
    }
}

