/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.paysdk.manager.utils;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.ImageView;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.pay.paysdk.manager.GlobalCache;
import com.transsion.pay.paysdk.manager.utils.PaySDKLogUtil;
import com.transsion.pay.paysdk.manager.utils.SPUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.UUID;

public class CommonUtils {
    public static final int TIME = 300;
    public static long lastClickTime = 0L;

    public static boolean isFastDoubleClick() {
        long l = System.currentTimeMillis();
        long l2 = l - lastClickTime;
        if (0L < l2 && l2 < 300L) {
            return true;
        }
        lastClickTime = l;
        return false;
    }

    public static boolean installed(String string2, Context context) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            return context.getPackageManager().getApplicationInfo(string2, 0) != null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static int getPackageCode(String string2, Activity activity) {
        block4: {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return -1;
            }
            string2 = activity.getPackageManager().getPackageInfo(string2, 0);
            if (string2 == null) break block4;
            try {
                return ((PackageInfo)string2).versionCode;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1;
    }

    public static String getPackageName(String string2, Activity activity) {
        block4: {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return "";
            }
            string2 = activity.getPackageManager().getPackageInfo(string2, 0);
            if (string2 == null) break block4;
            try {
                return ((PackageInfo)string2).versionName;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    public static String getSHA1(Context object) {
        StringBuffer stringBuffer;
        object = MessageDigest.getInstance("SHA1").digest(object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)64).signatures[0].toByteArray());
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            String string2;
            block16: {
                if (n >= ((Context)object).length) break;
                int n2 = 255;
                Context context = object[n];
                string2 = Integer.toHexString(context & n2).toUpperCase(Locale.US);
                if (string2.length() != 1) break block16;
                stringBuffer2.append("0");
            }
            StringBuffer stringBuffer3 = stringBuffer2;
            StringBuffer stringBuffer4 = stringBuffer3;
            stringBuffer3.append(string2);
            stringBuffer4.append(":");
            ++n;
        }
        String string3 = stringBuffer2.toString();
        int n3 = 0;
        int n4 = string3.length();
        try {
            return string3.substring(n3, n4 - 1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return null;
    }

    public static void loadImage(final ImageView imageView, final String string2) {
        try {
            GlobalCache.cachedThreadPool.submit(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    final Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new URL(string2).openStream());
                    try {
                        v0.imageView.post(new Runnable(){

                            @Override
                            public void run() {
                                imageView.setImageBitmap(bitmap);
                                PaySDKLogUtil.logE("a", "loadImage success");
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        PaySDKLogUtil.logE("a", "loadImage error:" + throwable.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            PaySDKLogUtil.logE("a", "loadImage error:" + exception.getMessage());
        }
    }

    public static String getDeviceId() {
        if (!TextUtils.isEmpty((CharSequence)DeviceInfo.getGAId())) {
            return DeviceInfo.getGAId();
        }
        String string2 = "123456";
        if (GlobalCache.getInstance().mContext != null && TextUtils.isEmpty((CharSequence)(string2 = SPUtils.getParam(GlobalCache.getInstance().mContext, "sp_gaid_info", "")))) {
            string2 = UUID.randomUUID().toString();
            SPUtils.setParam(GlobalCache.getInstance().mContext, "sp_gaid_info", string2);
        }
        return string2;
    }

    public static String getPackageName() {
        if (GlobalCache.getInstance().mContext != null) {
            return GlobalCache.getInstance().mContext.getPackageName();
        }
        return "";
    }

    public static String getCountryCode() {
        if (GlobalCache.getInstance().countryCurrencyData != null) {
            return GlobalCache.getInstance().countryCurrencyData.countryCode;
        }
        return "";
    }

    public static String getToken() {
        if (GlobalCache.getInstance().mContext != null) {
            return SPUtils.getParam(GlobalCache.getInstance().mContext, "ACCESS_TOKEN", "");
        }
        return "";
    }

    public static boolean getNightMode(Context context) {
        return ((UiModeManager)context.getSystemService("uimode")).getNightMode() == 2;
    }

    public static String getSysLanguage(Context context) {
        return context.getResources().getConfiguration().locale.getLanguage();
    }

    public static void showSoftKeyBoard(View view) {
        if (view == null) {
            return;
        }
        ((InputMethodManager)view.getContext().getSystemService("input_method")).showSoftInput(view, 0);
    }

    public static void hintKeyBoard(Activity activity) {
        if (activity == null) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager.isActive() && activity.getCurrentFocus() != null && activity.getCurrentFocus().getWindowToken() != null) {
            inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 2);
        }
    }

    public static void destroyWebview(WebView webView) {
        if (webView == null) {
            return;
        }
        WebView webView2 = webView;
        webView2.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
        if (webView2.getParent() != null) {
            ((ViewGroup)webView.getParent()).removeView((View)webView);
        }
        webView.destroy();
    }
}

