/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.paysdk.manager.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import androidx.core.graphics.ColorUtils;

public class StatusBarUtil {
    public static int FAKE_STATUS_BAR_VIEW_ID = 16908335;

    public static void setTransparentForWindow(Activity activity) {
        int n = Build.VERSION.SDK_INT;
        if (n >= 21) {
            Activity activity2 = activity;
            activity2.getWindow().setStatusBarColor(0);
            activity2.getWindow().getDecorView().setSystemUiVisibility(1280);
        } else if (n >= 19) {
            activity.getWindow().setFlags(0x4000000, 0x4000000);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setStatusBarStyle(Activity activity, boolean bl) {
        void var1_5;
        int n = activity.getWindow().getDecorView().getSystemUiVisibility();
        if (bl) {
            int n2 = n | 0x2000;
        } else {
            int n3 = n & 0xFFFFDFFF;
        }
        activity.getWindow().getDecorView().setSystemUiVisibility((int)var1_5);
    }

    /*
     * WARNING - void declaration
     */
    public static void setNavBarStyle(Activity activity, boolean bl) {
        void var1_5;
        int n = activity.getWindow().getDecorView().getSystemUiVisibility();
        if (bl) {
            int n2 = n | 0x10;
        } else {
            int n3 = n & 0xFFFFFFEF;
        }
        activity.getWindow().getDecorView().setSystemUiVisibility((int)var1_5);
    }

    public static void setNavBarColor(Activity activity, int n) {
        Activity activity2 = activity;
        int n2 = activity2.getResources().getColor(n);
        activity.getWindow().setNavigationBarColor(n2);
        StatusBarUtil.setNavBarStyle(activity2, StatusBarUtil.isLightColor(n2));
    }

    public static void setStatusBarColorInternal(Activity activity, int n) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 21) {
            Activity activity2 = activity;
            activity2.getWindow().addFlags(Integer.MIN_VALUE);
            activity2.getWindow().clearFlags(0x4000000);
            activity2.getWindow().setStatusBarColor(n);
        } else if (n2 >= 19) {
            Activity activity3 = activity;
            activity3.getWindow().addFlags(0x4000000);
            ViewGroup viewGroup = (ViewGroup)activity3.getWindow().getDecorView();
            View view = viewGroup.findViewById(FAKE_STATUS_BAR_VIEW_ID);
            if (view != null) {
                if (view.getVisibility() == 8) {
                    view.setVisibility(0);
                }
                view.setBackgroundColor(n);
            } else {
                View view2 = new View((Context)activity);
                view2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity)));
                view2.setBackgroundColor(n);
                view2.setId(FAKE_STATUS_BAR_VIEW_ID);
                viewGroup.addView(view2);
            }
            viewGroup = (ViewGroup)activity.findViewById(0x1020002);
            int n3 = viewGroup.getChildCount();
            for (int i = 0; i < n3; ++i) {
                View view3 = viewGroup.getChildAt(i);
                if (!(view3 instanceof ViewGroup)) continue;
                View view4 = view3;
                view4.setFitsSystemWindows(true);
                ((ViewGroup)view4).setClipToPadding(true);
            }
        }
        StatusBarUtil.setStatusBarStyle(activity, StatusBarUtil.isLightColor(n));
    }

    public static void setStatusBarColor(Activity activity, int n) {
        Activity activity2 = activity;
        StatusBarUtil.setStatusBarColorInternal(activity2, activity2.getResources().getColor(n));
    }

    public static void setStatusBarColor(Activity activity, int n, int n2) {
        Activity activity2 = activity;
        StatusBarUtil.setStatusBarColor(activity2, n);
        StatusBarUtil.setNavBarColor(activity2, n2);
    }

    public static int getStatusBarHeight(Context context) {
        int n;
        Context context2;
        try {
            Context context3 = context;
            context2 = context3;
            n = context3.getResources().getIdentifier("status_bar_height", "dimen", "android");
        }
        catch (Throwable throwable) {
            return 0;
        }
        return context2.getResources().getDimensionPixelSize(n);
    }

    public static boolean isLightColor(int n) {
        return ColorUtils.calculateLuminance((int)n) > 0.5;
    }

    public static void fullScreen(Activity activity) {
        int n = Build.VERSION.SDK_INT;
        if (n >= 19) {
            if (n >= 21) {
                Window window = activity.getWindow();
                window.getDecorView().setSystemUiVisibility(1280);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(0);
            } else {
                Window window = activity.getWindow();
                WindowManager.LayoutParams layoutParams = window.getAttributes();
                layoutParams.flags |= 0x4000000;
                window.setAttributes(layoutParams);
            }
        }
    }

    public static int dip2px(Context context, float f) {
        return (int)(f * context.getResources().getDisplayMetrics().density + 0.5f);
    }
}

