/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.mrouter;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.pay.mrouter.MRouter;
import java.util.Map;

public class Postcard {
    private String activityName;
    private Bundle mBundle;
    private String className = "";

    public Postcard(String activityPath) {
        Map<String, String> routes = MRouter.getInstance().getRoutes();
        if (routes != null && routes.size() > 0) {
            this.className = routes.get(activityPath);
        }
        this.activityName = this.className;
        this.mBundle = new Bundle();
    }

    public Postcard withString(String key, String value) {
        this.mBundle.putString(key, value);
        return this;
    }

    public Postcard withInt(String key, int value) {
        this.mBundle.putInt(key, value);
        return this;
    }

    public Postcard with(Bundle bundle) {
        if (null != bundle) {
            this.mBundle = bundle;
        }
        return this;
    }

    public boolean navigation(Activity context, int requestCode) {
        if (!TextUtils.isEmpty((CharSequence)this.activityName)) {
            try {
                Intent intent = new Intent();
                intent.setComponent(new ComponentName(context.getPackageName(), this.activityName));
                intent.putExtras(this.mBundle);
                context.startActivityForResult(intent, requestCode);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

