/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.paysdk.login;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.palmsdk.PalmAuthParam;
import com.transsion.palmsdk.PalmID;
import com.transsion.palmsdk.Scope;
import com.transsion.palmsdk.data.PalmAuthResult;
import com.transsion.pay.mrouter.Route;
import com.transsion.pay.paysdk.manager.ApiConsts;
import com.transsion.pay.paysdk.manager.GlobalCache;
import com.transsion.pay.paysdk.manager.entity.LoginResponse;
import com.transsion.pay.paysdk.manager.entity.Request;
import com.transsion.pay.paysdk.manager.inter.BaseLogin;
import com.transsion.pay.paysdk.manager.net.okhttp.NetClient;
import com.transsion.pay.paysdk.manager.net.okhttp.ObjectCallBack;
import com.transsion.pay.paysdk.manager.pay.PayUtil;
import com.transsion.pay.paysdk.manager.utils.PaySDKLogUtil;
import okhttp3.Call;
import okhttp3.Callback;

@Route(path="/login/palmid")
public class LoginManager
extends BaseLogin {
    public final String APPID;
    public LoginResponse.LoginInfo mLoginInfo;
    public final String ACTION_INNER_SIGN_IN;
    public final String ACTION_INNER_SIGN_OUT;
    public boolean mInit;

    public LoginManager() {
        this.APPID = "paynicorn";
        this.ACTION_INNER_SIGN_IN = "intent.action.inner.SIGN_IN";
        this.ACTION_INNER_SIGN_OUT = "intent.action.inner.SIGN_OUT";
    }

    public static /* synthetic */ LoginResponse.LoginInfo access$002(LoginManager loginManager, LoginResponse.LoginInfo loginInfo) {
        loginManager.mLoginInfo = loginInfo;
        return loginInfo;
    }

    public void init(final Context context) {
        IntentFilter intentFilter;
        IntentFilter intentFilter2;
        if (this.mInit) {
            return;
        }
        Context context2 = context.getApplicationContext();
        this.mInit = true;
        IntentFilter intentFilter3 = intentFilter2;
        new IntentFilter().addAction("intent.action.inner.SIGN_IN");
        intentFilter3.addAction("intent.action.inner.SIGN_OUT");
        this.authorize(context2, null);
        LocalBroadcastManager.getInstance((Context)context2).registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getAction();
                boolean bl = LoginResponse.LoginInfo.isValid((LoginResponse.LoginInfo)LoginManager.this.mLoginInfo);
                if (TextUtils.equals((CharSequence)"intent.action.inner.SIGN_IN", (CharSequence)object)) {
                    if (!bl) {
                        LoginManager.this.authorize(context, null);
                    }
                } else if (bl) {
                    LoginManager loginManager = LoginManager.this;
                    loginManager.logout(((LoginManager)loginManager).mLoginInfo.token);
                }
            }
        }, intentFilter3);
        context = intentFilter;
        intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context2.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (!LoginResponse.LoginInfo.isValid((LoginResponse.LoginInfo)LoginManager.this.mLoginInfo) && PayUtil.isNetworkConnected((Context)context)) {
                    LoginManager.this.authorize(context, null);
                }
            }
        }, (IntentFilter)context);
    }

    public void login(final Activity activity) {
        PalmID.IPalmAuthListener iPalmAuthListener;
        PalmID palmID = PalmID.createInstance((Context)activity, (PalmAuthParam)new PalmAuthParam.Builder().setAppid("paynicorn").setRedirectUri("https://dev-account.palm.tech/client/callback").setScopes(new String[]{Scope.INFO_BASIC, Scope.TRADE_ADDR}).requestToken().build());
        PalmID.IPalmAuthListener iPalmAuthListener2 = iPalmAuthListener;
        iPalmAuthListener = new PalmID.IPalmAuthListener(this){

            public void onSuccess(final PalmAuthResult palmAuthResult) {
                PayUtil.runOnMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)activity, (CharSequence)("login authcode:" + palmAuthResult.getAuthCode()), (int)1).show();
                    }
                });
                PaySDKLogUtil.logE((String)"TranssionPay", (String)("login onSuccess authcode:" + palmAuthResult.getAuthCode()));
            }

            public void onCancel() {
            }

            public void onFailure(int n, String string) {
                PaySDKLogUtil.logE((String)"TranssionPay", (String)("login onFailure msg:" + string));
            }
        };
        palmID.authorize(activity, iPalmAuthListener2);
        palmID.listenPalmAppStatus(new PalmID.IPalmStatusListener(this){

            public void onSignIn(int n) {
            }

            public void onSignOut(int n) {
                PaySDKLogUtil.logE((String)"TranssionPay", (String)("onSignOut = " + n));
            }
        });
    }

    public void authorize(Context context, final BaseLogin.LoginCallBack loginCallBack) {
        PalmID.IPalmAuthListener iPalmAuthListener;
        Object object = PalmID.createInstance((Context)context, (PalmAuthParam)(context = new PalmAuthParam.Builder().setAppid("paynicorn").build()));
        if (object == null) {
            return;
        }
        PalmID palmID = object;
        object = iPalmAuthListener;
        iPalmAuthListener = new PalmID.IPalmAuthListener(){

            public void onSuccess(PalmAuthResult object) {
                object = object.getAuthCode();
                PaySDKLogUtil.logE((String)"TranssionPay", (String)("authorize onSuccess authcode:" + (String)object));
                LoginManager.this.login((String)object, loginCallBack);
            }

            public void onCancel() {
            }

            public void onFailure(int n, String string) {
                PaySDKLogUtil.logE((String)"TranssionPay", (String)("authorize onFailure msg:" + string));
            }
        };
        palmID.authorize((PalmAuthParam)context, (PalmID.IPalmAuthListener)object);
    }

    public void login(String string, final BaseLogin.LoginCallBack loginCallBack) {
        ObjectCallBack<LoginResponse.LoginInfo> objectCallBack;
        Request.LoginRequest loginRequest;
        Request.LoginRequest loginRequest2 = loginRequest;
        loginRequest2();
        loginRequest.deviceInfo = this.getGaid();
        loginRequest.sign = new Request.LoginRequest.Sign(string);
        this.mLoginInfo = null;
        string = objectCallBack;
        objectCallBack = new ObjectCallBack<LoginResponse.LoginInfo>(){

            public void onFailure(Call call, int n, String string) {
                f f2 = f2.loginCallBack;
                if (f2 != null) {
                    f2.result(null);
                } else {
                    GlobalCache.loginInfo = null;
                }
            }

            public void onResponse(Call call, Object object) {
                f f2;
                call = (LoginResponse.LoginInfo)object;
                PaySDKLogUtil.logE((String)"TranssionPay", (String)("response:" + call.token));
                if (TextUtils.equals((CharSequence)call.code, (CharSequence)"200")) {
                    f f3 = f2;
                    LoginManager.access$002(f3.LoginManager.this, (LoginResponse.LoginInfo)call);
                    f2 = f3.loginCallBack;
                    if (f2 != null) {
                        f2.result((LoginResponse.LoginInfo)call);
                    } else {
                        GlobalCache.loginInfo = call;
                    }
                } else {
                    f2 = f2.loginCallBack;
                    if (f2 != null) {
                        f2.result(null);
                    } else {
                        GlobalCache.loginInfo = null;
                    }
                }
            }
        };
        NetClient.requestPost((String)ApiConsts.LOGIN, (Object)loginRequest2, (Callback)string);
    }

    public void logout(String string) {
        ObjectCallBack<String> objectCallBack;
        Request.LogoutRequest logoutRequest;
        Request.LogoutRequest logoutRequest2 = logoutRequest;
        logoutRequest2();
        logoutRequest.token = string;
        string = objectCallBack;
        objectCallBack = new ObjectCallBack<String>(this){

            public void onFailure(Call call, int n, String string) {
            }

            public void onResponse(Call call, Object object) {
                String cfr_ignored_0 = (String)object;
            }
        };
        NetClient.requestPost((String)ApiConsts.LOGOUT, (Object)logoutRequest2, (Callback)string);
        this.mLoginInfo = null;
    }

    public String getGaid() {
        return DeviceInfo.getGAId();
    }
}

