/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui;

import android.content.res.Configuration;
import android.graphics.Rect;
import androidx.window.layout.DisplayFeature;
import androidx.window.layout.FoldingFeature;
import androidx.window.layout.WindowLayoutInfo;
import com.transsion.responsiveui.Screen;
import java.util.List;

public final class ResponsiveConfiguration {
    private Configuration configuration;
    private WindowLayoutInfo windowLayoutInfo;
    private int screenState = 0;
    private Screen.ScreenSize screenSize;
    private FoldingFeature foldingFeature;
    public int orientation;

    public ResponsiveConfiguration(Configuration configuration) {
        this(configuration, null);
    }

    public ResponsiveConfiguration(Configuration configuration, WindowLayoutInfo windowLayoutInfo) {
        this.configuration = configuration;
        this.updateWindowLayoutInfo(windowLayoutInfo);
    }

    public void updateConfiguration(Configuration newConfig) {
        this.configuration = newConfig;
        this.orientation = this.configuration.orientation;
    }

    public void updateWindowLayoutInfo(WindowLayoutInfo layoutInfo) {
        this.windowLayoutInfo = layoutInfo;
        if (this.windowLayoutInfo == null || this.windowLayoutInfo.getDisplayFeatures().size() == 0) {
            this.orientation = this.configuration.orientation;
            this.screenState = 0;
            this.foldingFeature = null;
            return;
        }
        List displayFeatures = this.windowLayoutInfo.getDisplayFeatures();
        for (DisplayFeature feature : displayFeatures) {
            if (!(feature instanceof FoldingFeature)) continue;
            this.foldingFeature = (FoldingFeature)feature;
            this.orientation = this.foldingFeature.getOrientation() == FoldingFeature.Orientation.HORIZONTAL ? 2 : 1;
            this.screenState = 0;
            if (this.foldingFeature.getState() == FoldingFeature.State.HALF_OPENED) {
                this.screenState = 2;
                continue;
            }
            if (this.foldingFeature.getState() != FoldingFeature.State.FLAT) continue;
            this.screenState = 1;
        }
    }

    public int getScreenState() {
        return this.screenState;
    }

    public void updateScreenSize(Screen.ScreenSize size) {
        this.screenSize = size;
    }

    public Screen.ScreenSize getScreenSize() {
        return this.screenSize;
    }

    public Rect getBounds() {
        return this.foldingFeature != null ? this.foldingFeature.getBounds() : new Rect();
    }

    public boolean isTableTopPosture() {
        return this.foldingFeature != null && this.foldingFeature.getState() == FoldingFeature.State.HALF_OPENED && this.foldingFeature.getOrientation() == FoldingFeature.Orientation.HORIZONTAL;
    }

    public boolean isBookPosture() {
        return this.foldingFeature != null && this.foldingFeature.getState() == FoldingFeature.State.HALF_OPENED && this.foldingFeature.getOrientation() == FoldingFeature.Orientation.VERTICAL;
    }

    public boolean isSeparating() {
        return this.foldingFeature != null && this.foldingFeature.getState() == FoldingFeature.State.FLAT && this.foldingFeature.isSeparating();
    }

    public String toString() {
        return "ResponsiveConfiguration{ screenState=" + this.screenState + ",\n configuration=" + this.configuration + ",\n windowLayoutInfo=" + this.windowLayoutInfo + '}';
    }
}

