/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui;

import android.content.Context;
import android.util.Log;
import androidx.core.util.Consumer;
import androidx.window.layout.WindowLayoutInfo;
import com.transsion.responsiveui.OnResponsiveLayoutChangeListener;
import com.transsion.responsiveui.ResponsiveConfiguration;
import com.transsion.responsiveui.ScreenUtils;

public class ResponsiveStateConsumer
implements Consumer<WindowLayoutInfo> {
    private static final String TAG = "ResponsiveStateConsumer";
    private Context mContext;
    private OnResponsiveLayoutChangeListener mListener;

    public ResponsiveStateConsumer(Context context, OnResponsiveLayoutChangeListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public void accept(WindowLayoutInfo windowLayoutInfo) {
        ResponsiveConfiguration configuration = new ResponsiveConfiguration(this.mContext.getResources().getConfiguration(), windowLayoutInfo);
        configuration.updateWindowLayoutInfo(windowLayoutInfo);
        configuration.updateScreenSize(ScreenUtils.getScreenSize(this.mContext));
        Log.i((String)TAG, (String)("StateContainer bounds ===>>> \n" + configuration.getBounds()));
        Log.i((String)TAG, (String)("StateContainer accept ===>>> \n" + configuration.getScreenState()));
        if (this.mListener != null) {
            this.mListener.onResponsiveLayout(configuration);
        }
    }
}

