/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import com.transsion.responsiveui.IAdaptiveUI;
import com.transsion.responsiveui.IAdaptiveView;
import com.transsion.responsiveui.OnResponsiveLayoutChangeListener;
import com.transsion.responsiveui.ResponsiveChangeRegister;
import com.transsion.responsiveui.context.ActivityResponsive;
import com.transsion.responsiveui.context.FragmentResponsive;
import com.transsion.responsiveui.context.ResponsiveContext;
import com.transsion.responsiveui.context.ViewResponsive;
import java.util.ArrayList;
import java.util.List;

public final class ResponsiveUI {
    private static final String TAG = "ResponsiveUI";
    private ResponsiveContext mResponsiveContext;
    private List<IAdaptiveUI> mAdaptiveViews;

    private ResponsiveUI(ResponsiveContext responsive) {
        this.mResponsiveContext = responsive;
        this.mAdaptiveViews = new ArrayList<IAdaptiveUI>();
    }

    public static ResponsiveUI with(FragmentActivity activity) {
        ActivityResponsive responsive = ResponsiveChangeRegister.getOrCreateActivityResponsive((Context)activity);
        return ResponsiveUI.with(responsive, null);
    }

    public static ResponsiveUI with(Fragment fragment) {
        return ResponsiveUI.with(new FragmentResponsive(fragment), null);
    }

    public static ResponsiveUI with(IAdaptiveView adaptiveView) {
        return ResponsiveUI.with(new ViewResponsive((View)adaptiveView.currentView()), adaptiveView);
    }

    public static ResponsiveUI with(ResponsiveContext responsive, IAdaptiveUI adaptiveUI) {
        ResponsiveUI responsiveUI = new ResponsiveUI(responsive);
        if (adaptiveUI != null) {
            responsiveUI.addAdaptiveUI(adaptiveUI);
        }
        return responsiveUI;
    }

    public ResponsiveUI addAdaptiveUI(IAdaptiveUI adaptiveUI) {
        if (this.mAdaptiveViews != null && !this.mAdaptiveViews.contains(adaptiveUI)) {
            this.mAdaptiveViews.add(adaptiveUI);
        }
        return this;
    }

    public ResponsiveUI removeAdaptiveUI(IAdaptiveUI adaptiveUI) {
        if (this.mAdaptiveViews != null) {
            this.mAdaptiveViews.remove(adaptiveUI);
        }
        return this;
    }

    public ResponsiveUI addResponsiveLayoutChangeListener(OnResponsiveLayoutChangeListener listener) {
        if (this.mResponsiveContext != null) {
            this.mResponsiveContext.addResponsiveLayoutChangeListener(listener);
        }
        return this;
    }

    public ResponsiveUI removeResponsiveLayoutChangeListener(OnResponsiveLayoutChangeListener listener) {
        if (this.mResponsiveContext != null) {
            this.mResponsiveContext.removeResponsiveLayoutChangeListener(listener);
        }
        return this;
    }

    public ResponsiveUI applyChange(Context context) {
        this.checkShouldAddWindowInfoListener(context);
        OnResponsiveLayoutChangeListener callback = newConfiguration -> {
            for (IAdaptiveUI adaptiveUI : this.mAdaptiveViews) {
                adaptiveUI.applyLayoutChange(newConfiguration);
            }
        };
        this.mResponsiveContext.applyOnConfigChange(context);
        this.mResponsiveContext.addResponsiveLayoutChangeListener(callback);
        return this;
    }

    private void checkShouldAddWindowInfoListener(Context context) {
        ActivityResponsive responsive = ResponsiveChangeRegister.getOrCreateActivityResponsive(context);
        if (responsive != null) {
            Activity activity = responsive.getActivity();
            if (!(activity instanceof AppCompatActivity)) {
                return;
            }
            Lifecycle lifecycle = ((AppCompatActivity)activity).getLifecycle();
            if (lifecycle == null) {
                return;
            }
            Lifecycle.State state = lifecycle.getCurrentState();
            if (state == Lifecycle.State.STARTED || state == Lifecycle.State.INITIALIZED) {
                responsive.addWindowLayoutInfoListener();
                Log.i((String)TAG, (String)"checkShouldAddWindowInfoListener, addWindowLayoutInfoListener");
            }
        }
    }
}

