/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui.context;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.core.util.Consumer;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.window.java.layout.WindowInfoTrackerCallbackAdapter;
import androidx.window.layout.WindowInfoTracker;
import com.transsion.responsiveui.ResponsiveStateConsumer;
import com.transsion.responsiveui.context.BaseResponsive;
import java.util.concurrent.Executor;

public class ActivityResponsive
extends BaseResponsive
implements LifecycleEventObserver {
    public static final String TAG = "ResponsiveContext";
    private ResponsiveStateConsumer stateConsumer;
    private WindowInfoTrackerCallbackAdapter windowInfoTracker;
    private final Handler handler;
    private final Executor executor;
    private Activity mActivity;

    public ActivityResponsive(Activity activity) {
        this.mActivity = activity;
        this.handler = new Handler(Looper.getMainLooper());
        this.executor = command -> this.handler.post(() -> this.handler.post(command));
        this.mActivity = activity;
        if (this.mActivity instanceof ComponentActivity) {
            Lifecycle lifecycle = ((ComponentActivity)this.mActivity).getLifecycle();
            lifecycle.addObserver((LifecycleObserver)this);
        }
    }

    public void addWindowLayoutInfoListener() {
        if (this.stateConsumer == null) {
            this.stateConsumer = new ResponsiveStateConsumer((Context)this.mActivity, this);
        }
        this.registerResponsiveStateConsumer(this.stateConsumer);
    }

    public void removeWindowLayoutInfoListener() {
        if (this.windowInfoTracker != null && this.stateConsumer != null) {
            this.windowInfoTracker.removeWindowLayoutInfoListener((Consumer)this.stateConsumer);
            this.stateConsumer = null;
        }
    }

    public void registerResponsiveStateConsumer(ResponsiveStateConsumer consumer) {
        if (this.windowInfoTracker == null) {
            this.windowInfoTracker = new WindowInfoTrackerCallbackAdapter(WindowInfoTracker.getOrCreate((Context)this.mActivity));
        }
        if (this.windowInfoTracker != null && consumer != null) {
            this.windowInfoTracker.addWindowLayoutInfoListener(this.mActivity, this.executor, (Consumer)consumer);
        }
    }

    public void unRegisterResponsiveStateConsumer(ResponsiveStateConsumer consumer) {
        if (this.windowInfoTracker != null && consumer != null) {
            this.windowInfoTracker.removeWindowLayoutInfoListener((Consumer)consumer);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.windowInfoTracker != null && this.stateConsumer != null) {
            this.windowInfoTracker.removeWindowLayoutInfoListener((Consumer)this.stateConsumer);
            this.windowInfoTracker = null;
        }
        if (this.mActivity != null) {
            if (this.mActivity instanceof ComponentActivity) {
                ((ComponentActivity)this.mActivity).getLifecycle().removeObserver((LifecycleObserver)this);
            }
            this.unRegisterComponentCallbacks((Context)this.mActivity);
            this.mActivity = null;
        }
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        Log.i((String)TAG, (String)("Lifecycle onStateChanged, event: " + event));
        if (event == Lifecycle.Event.ON_START) {
            this.addWindowLayoutInfoListener();
        } else if (event == Lifecycle.Event.ON_STOP) {
            this.removeWindowLayoutInfoListener();
        } else if (event == Lifecycle.Event.ON_DESTROY) {
            this.onDestroy();
        }
    }
}

