/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui.context;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import com.transsion.responsiveui.OnResponsiveLayoutChangeListener;
import com.transsion.responsiveui.ResponsiveConfiguration;
import com.transsion.responsiveui.context.ResponsiveContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseResponsive
implements ResponsiveContext,
OnResponsiveLayoutChangeListener,
ComponentCallbacks {
    private static final String TAG = "BaseResponsive";
    private List<OnResponsiveLayoutChangeListener> mLayoutChangeListeners = Collections.synchronizedList(new ArrayList());
    private ResponsiveConfiguration mConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResponsiveLayoutChangeListener(OnResponsiveLayoutChangeListener listener) {
        List<OnResponsiveLayoutChangeListener> list = this.mLayoutChangeListeners;
        synchronized (list) {
            if (!this.mLayoutChangeListeners.contains(listener)) {
                this.mLayoutChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponsiveLayoutChangeListener(OnResponsiveLayoutChangeListener listener) {
        List<OnResponsiveLayoutChangeListener> list = this.mLayoutChangeListeners;
        synchronized (list) {
            this.mLayoutChangeListeners.remove(listener);
        }
    }

    @Override
    public void applyOnConfigChange(Context context) {
        this.registerComponentCallbacks(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponsiveLayout(ResponsiveConfiguration newConfiguration) {
        Log.i((String)TAG, (String)("onResponsiveLayout -> " + newConfiguration.getScreenState()));
        this.mConfiguration = newConfiguration;
        List<OnResponsiveLayoutChangeListener> list = this.mLayoutChangeListeners;
        synchronized (list) {
            for (OnResponsiveLayoutChangeListener listener : this.mLayoutChangeListeners) {
                listener.onResponsiveLayout(newConfiguration);
            }
        }
    }

    @CallSuper
    public void onDestroy() {
        this.mLayoutChangeListeners.clear();
    }

    protected void registerComponentCallbacks(Context context) {
        Context appContext = context.getApplicationContext();
        if (appContext != null) {
            appContext.registerComponentCallbacks((ComponentCallbacks)this);
        }
    }

    protected void unRegisterComponentCallbacks(Context context) {
        Context appContext = context.getApplicationContext();
        if (appContext != null) {
            appContext.unregisterComponentCallbacks((ComponentCallbacks)this);
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        Log.i((String)TAG, (String)("onConfigurationChanged ==> \n " + newConfig));
        if (newConfig.orientation == this.mConfiguration.orientation) {
            return;
        }
        if (this.mConfiguration == null) {
            this.mConfiguration = new ResponsiveConfiguration(newConfig);
        } else {
            this.mConfiguration.updateConfiguration(newConfig);
        }
        this.onResponsiveLayout(this.mConfiguration);
    }

    public void onLowMemory() {
        Log.i((String)TAG, (String)"onLowMemory");
    }
}

