/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui.context;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.transsion.responsiveui.ResponsiveChangeRegister;
import com.transsion.responsiveui.ResponsiveStateConsumer;
import com.transsion.responsiveui.context.ActivityResponsive;
import com.transsion.responsiveui.context.BaseResponsive;

public class FragmentResponsive
extends BaseResponsive
implements LifecycleEventObserver {
    private static final String TAG = "FragmentResponsive";
    private Fragment mFragment;
    private ResponsiveStateConsumer mStateConsumer;

    public FragmentResponsive(Fragment fragment) {
        this.mFragment = fragment;
        this.mFragment.getLifecycle().addObserver((LifecycleObserver)this);
        if (this.mFragment.isAdded()) {
            this.addWindowLayoutInfoListener();
        }
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        Log.i((String)TAG, (String)("Lifecycle onStateChanged, event: " + event));
        if (event == Lifecycle.Event.ON_START) {
            this.addWindowLayoutInfoListener();
        } else if (event == Lifecycle.Event.ON_STOP) {
            this.removeWindowLayoutInfoListener();
        } else if (event == Lifecycle.Event.ON_DESTROY) {
            this.onDestroy();
        }
    }

    public void addWindowLayoutInfoListener() {
        Context context = this.mFragment.getContext();
        FragmentActivity activity = this.mFragment.getActivity();
        ActivityResponsive activityResponsive = ResponsiveChangeRegister.getOrCreateActivityResponsive((Context)activity);
        if (activityResponsive != null) {
            if (this.mStateConsumer == null) {
                this.mStateConsumer = new ResponsiveStateConsumer(context, this);
            }
            activityResponsive.registerResponsiveStateConsumer(this.mStateConsumer);
        }
    }

    public void removeWindowLayoutInfoListener() {
        FragmentActivity activity = this.mFragment.getActivity();
        ActivityResponsive activityResponsive = ResponsiveChangeRegister.getOrCreateActivityResponsive((Context)activity);
        if (activityResponsive != null && this.mStateConsumer != null) {
            activityResponsive.unRegisterResponsiveStateConsumer(this.mStateConsumer);
            this.mStateConsumer = null;
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.removeWindowLayoutInfoListener();
        this.mStateConsumer = null;
    }
}

