/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui.context;

import android.content.Context;
import android.view.View;
import com.transsion.responsiveui.ResponsiveChangeRegister;
import com.transsion.responsiveui.ResponsiveStateConsumer;
import com.transsion.responsiveui.context.ActivityResponsive;
import com.transsion.responsiveui.context.BaseResponsive;

public class ViewResponsive
extends BaseResponsive
implements View.OnAttachStateChangeListener {
    private View mView;
    private ResponsiveStateConsumer mStateConsumer;

    public ViewResponsive(View view) {
        this.mView = view;
        if (this.mView.isAttachedToWindow()) {
            this.registerResponsiveStateConsumer(view.getContext());
        }
        this.mView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    public void onViewAttachedToWindow(View v) {
        Context context = v.getContext();
        if (context == null) {
            return;
        }
        this.registerResponsiveStateConsumer(context);
    }

    public void onViewDetachedFromWindow(View v) {
        Context context = v.getContext();
        if (context == null) {
            return;
        }
        ActivityResponsive activityResponsive = ResponsiveChangeRegister.getOrCreateActivityResponsive(context);
        if (activityResponsive != null && this.mStateConsumer != null) {
            activityResponsive.unRegisterResponsiveStateConsumer(this.mStateConsumer);
            this.mStateConsumer = null;
        }
    }

    private void registerResponsiveStateConsumer(Context context) {
        ActivityResponsive activityResponsive = ResponsiveChangeRegister.getOrCreateActivityResponsive(context);
        if (activityResponsive != null) {
            if (this.mStateConsumer == null) {
                this.mStateConsumer = new ResponsiveStateConsumer(context, this);
            }
            activityResponsive.registerResponsiveStateConsumer(this.mStateConsumer);
        }
    }
}

