/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui.scene;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.transsion.responsiveui.IAdaptiveView;
import com.transsion.responsiveui.ResponsiveConfiguration;
import com.transsion.responsiveui.ResponsiveUI;

public class MovePanelAdaptiveView
extends LinearLayout
implements IAdaptiveView<LinearLayout> {
    private int currentState;

    public MovePanelAdaptiveView(Context context) {
        this(context, null);
    }

    public MovePanelAdaptiveView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public MovePanelAdaptiveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ResponsiveUI.with(this).applyChange(context);
    }

    @Override
    public void applyLayoutChange(ResponsiveConfiguration configuration) {
        int screenState = configuration.getScreenState();
        int childCount = this.getChildCount();
        if (childCount != 2 || this.currentState == screenState) {
            return;
        }
        View upLayout = this.getChildAt(0);
        View downLayout = this.getChildAt(1);
        if (screenState == 0) {
            this.translateUpDown(upLayout, downLayout);
        } else if (screenState == 1) {
            this.translateLeftRight(upLayout, downLayout);
        }
        this.requestLayout();
        this.currentState = screenState;
    }

    @Override
    public LinearLayout currentView() {
        return this;
    }

    private void translateLeftRight(View leftView, View rightView) {
        this.setOrientation(0);
        LinearLayout.LayoutParams leftParams = (LinearLayout.LayoutParams)leftView.getLayoutParams();
        leftParams.width = -2;
        leftParams.weight = 1.0f;
        LinearLayout.LayoutParams rightParams = (LinearLayout.LayoutParams)rightView.getLayoutParams();
        rightParams.width = -2;
        rightParams.leftMargin = 0;
        rightParams.weight = 1.0f;
    }

    private void translateUpDown(View upView, View downView) {
        this.setOrientation(1);
        LinearLayout.LayoutParams upParams = (LinearLayout.LayoutParams)upView.getLayoutParams();
        upParams.width = -1;
        upParams.weight = 0.0f;
        LinearLayout.LayoutParams downParams = (LinearLayout.LayoutParams)downView.getLayoutParams();
        downParams.width = -1;
        downParams.weight = 0.0f;
    }
}

