/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.responsiveui.scene;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.transsion.responsiveui.IAdaptiveView;
import com.transsion.responsiveui.ResponsiveConfiguration;
import com.transsion.responsiveui.ResponsiveUI;

public class SplitPanelAdaptiveView
extends ViewGroup
implements IAdaptiveView<ViewGroup> {
    private ResponsiveConfiguration mConfiguration;

    public SplitPanelAdaptiveView(Context context) {
        this(context, null);
    }

    public SplitPanelAdaptiveView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public SplitPanelAdaptiveView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mConfiguration = new ResponsiveConfiguration(context.getResources().getConfiguration());
        ResponsiveUI.with(this).applyChange(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        if (childCount < 2 || this.isScreenStateNone()) {
            this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        } else {
            View childStage = this.getChildAt(0);
            View childExpand = this.getChildAt(1);
            int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            if (this.isScreenFlat()) {
                int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(parentWidth / 2), (int)0x40000000);
                childStage.measure(newWidthSpec, heightMeasureSpec);
                childExpand.measure(newWidthSpec, heightMeasureSpec);
            } else {
                this.measureChildren(widthMeasureSpec, heightMeasureSpec);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mConfiguration == null || this.getChildCount() < 2) {
            return;
        }
        View childStage = this.getChildAt(0);
        View childExpand = this.getChildAt(1);
        if (childExpand.getVisibility() == 0) {
            childStage.layout(l, t, l + childStage.getMeasuredWidth(), b);
            childExpand.layout(l + childStage.getMeasuredWidth(), t, r, b);
        } else {
            childStage.layout(l, t, r, b);
        }
    }

    @Override
    public void applyLayoutChange(ResponsiveConfiguration configuration) {
        this.mConfiguration = configuration;
        int childCount = this.getChildCount();
        if (childCount < 2) {
            return;
        }
        this.requestLayout();
    }

    @Override
    public ViewGroup currentView() {
        return this;
    }

    private boolean isScreenFlat() {
        return this.mConfiguration != null && this.mConfiguration.getScreenState() == 1;
    }

    private boolean isScreenStateNone() {
        return this.mConfiguration != null && this.mConfiguration.getScreenState() == 0;
    }
}

